/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.integration.service;

import com.alipay.sofa.ark.spi.event.ArkEvent;
import com.alipay.sofa.ark.spi.event.BizEvent;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.event.EventHandler;
import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.SofaRuntimeProperties;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;

public class SofaEventHandler
implements EventHandler {
    public void handleEvent(ArkEvent event) {
        if ("AFTER-INVOKE-BIZ-STOP".equals(event.getTopic())) {
            this.doUninstallBiz((BizEvent)event);
        } else if ("AFTER-INVOKE-BIZ-START".equals(event.getTopic())) {
            this.doHealthCheck((BizEvent)event);
        }
    }

    private void doUninstallBiz(BizEvent event) {
        SofaRuntimeProperties.unRegisterProperties(event.getBiz().getBizClassLoader());
        SofaRuntimeManager sofaRuntimeManager = this.getSofaRuntimeManager(event.getBiz());
        SofaFramework.unRegisterSofaRuntimeManager(sofaRuntimeManager);
        sofaRuntimeManager.shutdown();
    }

    private void doHealthCheck(BizEvent event) {
        SofaRuntimeManager sofaRuntimeManager = this.getSofaRuntimeManager(event.getBiz());
        if (!sofaRuntimeManager.isHealthCheckPassed()) {
            throw new RuntimeException("Health check failed.");
        }
    }

    private SofaRuntimeManager getSofaRuntimeManager(Biz biz) {
        for (SofaRuntimeManager sofaRuntimeManager : SofaFramework.getRuntimeSet()) {
            if (!sofaRuntimeManager.getAppClassLoader().equals(biz.getBizClassLoader())) continue;
            return sofaRuntimeManager;
        }
        throw new RuntimeException("No SofaRuntimeManager Found!");
    }

    public int getPriority() {
        return 100;
    }
}

