/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.runtime.annotation.PlaceHolderAnnotationInvocationHandler;
import com.alipay.sofa.runtime.annotation.PlaceHolderBinder;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.service.component.impl.ReferenceImpl;
import com.alipay.sofa.runtime.service.helper.ReferenceRegisterHelper;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReferenceAnnotationBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private final PlaceHolderBinder binder = new DefaultPlaceHolderBinder();
    private ApplicationContext applicationContext;
    private SofaRuntimeContext sofaRuntimeContext;
    private BindingAdapterFactory bindingAdapterFactory;
    private BindingConverterFactory bindingConverterFactory;
    private Environment environment;

    public ReferenceAnnotationBeanPostProcessor(ApplicationContext applicationContext, SofaRuntimeContext sofaRuntimeContext, BindingAdapterFactory bindingAdapterFactory, BindingConverterFactory bindingConverterFactory) {
        this.applicationContext = applicationContext;
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.bindingAdapterFactory = bindingAdapterFactory;
        this.bindingConverterFactory = bindingConverterFactory;
        this.environment = applicationContext.getEnvironment();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processSofaReference(bean);
        return bean;
    }

    private void processSofaReference(final Object bean) {
        Class<?> beanClass = bean.getClass();
        ReflectionUtils.doWithFields(beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder builder = PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder.wrap(field.getAnnotation(SofaReference.class)).withBinder(ReferenceAnnotationBeanPostProcessor.this.binder);
                SofaReference sofaReferenceAnnotation = (SofaReference)builder.build();
                if (sofaReferenceAnnotation == null) {
                    return;
                }
                Class<?> interfaceType = sofaReferenceAnnotation.interfaceType();
                if (interfaceType.equals(Void.TYPE)) {
                    interfaceType = field.getType();
                }
                Object proxy = ReferenceAnnotationBeanPostProcessor.this.createReferenceProxy(sofaReferenceAnnotation, interfaceType);
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)bean, (Object)proxy);
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                return !Modifier.isStatic(field.getModifiers()) && field.isAnnotationPresent(SofaReference.class);
            }
        });
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Class<?>[] parameterTypes = method.getParameterTypes();
                Assert.isTrue((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"method should have one and only one parameter.");
                SofaReference sofaReferenceAnnotation = method.getAnnotation(SofaReference.class);
                if (sofaReferenceAnnotation == null) {
                    return;
                }
                PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder builder = PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder.wrap(sofaReferenceAnnotation).withBinder(ReferenceAnnotationBeanPostProcessor.this.binder);
                Class<?> interfaceType = (sofaReferenceAnnotation = (SofaReference)builder.build()).interfaceType();
                if (interfaceType.equals(Void.TYPE)) {
                    interfaceType = parameterTypes[0];
                }
                Object proxy = ReferenceAnnotationBeanPostProcessor.this.createReferenceProxy(sofaReferenceAnnotation, interfaceType);
                ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{proxy});
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return method.isAnnotationPresent(SofaReference.class);
            }
        });
    }

    private Object createReferenceProxy(SofaReference sofaReferenceAnnotation, Class<?> interfaceType) {
        ReferenceImpl reference = new ReferenceImpl(sofaReferenceAnnotation.uniqueId(), interfaceType, InterfaceMode.annotation, sofaReferenceAnnotation.jvmFirst());
        BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(new BindingType(sofaReferenceAnnotation.binding().bindingType()));
        if (bindingConverter == null) {
            throw new ServiceRuntimeException("Can not found binding converter for binding type " + sofaReferenceAnnotation.binding().bindingType());
        }
        BindingConverterContext bindingConverterContext = new BindingConverterContext();
        bindingConverterContext.setInBinding(true);
        bindingConverterContext.setApplicationContext(this.applicationContext);
        bindingConverterContext.setAppName(this.sofaRuntimeContext.getAppName());
        bindingConverterContext.setAppClassLoader(this.sofaRuntimeContext.getAppClassLoader());
        Object binding = bindingConverter.convert(sofaReferenceAnnotation, sofaReferenceAnnotation.binding(), bindingConverterContext);
        reference.addBinding(binding);
        return ReferenceRegisterHelper.registerReference(reference, this.bindingAdapterFactory, this.sofaRuntimeContext);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    class DefaultPlaceHolderBinder
    implements PlaceHolderBinder {
        DefaultPlaceHolderBinder() {
        }

        @Override
        public String bind(String text) {
            return ReferenceAnnotationBeanPostProcessor.this.environment.resolvePlaceholders(text);
        }
    }
}

