/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spi.service;

import com.alipay.sofa.runtime.util.StringUtils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class ServiceProxy
implements MethodInterceptor {
    private ClassLoader serviceClassLoader;

    public ServiceProxy(ClassLoader serviceClassLoader) {
        this.serviceClassLoader = serviceClassLoader;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        long startTime = System.currentTimeMillis();
        try {
            Thread.currentThread().setContextClassLoader(this.serviceClassLoader);
            Object object = this.doInvoke(invocation);
            return object;
        }
        catch (Throwable e) {
            this.doCatch(invocation, e, startTime);
            throw e;
        }
        finally {
            this.doFinally(invocation, startTime);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected void pushThreadContextClassLoader(ClassLoader newContextClassLoader) {
        if (newContextClassLoader != null) {
            Thread.currentThread().setContextClassLoader(newContextClassLoader);
        }
    }

    protected void popThreadContextClassLoader(ClassLoader tcl) {
        Thread.currentThread().setContextClassLoader(tcl);
    }

    protected String getCommonInvocationLog(String start, MethodInvocation invocation, long startTime) {
        String appStart = "";
        if (StringUtils.hasText(appStart)) {
            appStart = "-" + start;
        }
        long endTime = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder("SOFA-Reference" + appStart + "(");
        sb.append(invocation.getMethod().getName()).append(",");
        for (Object o : invocation.getArguments()) {
            sb.append(o);
            sb.append(",");
        }
        sb.append(endTime - startTime).append("ms").append(")");
        return sb.toString();
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    protected abstract Object doInvoke(MethodInvocation var1) throws Throwable;

    protected abstract void doCatch(MethodInvocation var1, Throwable var2, long var3);

    protected abstract void doFinally(MethodInvocation var1, long var2);
}

