/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spi.util;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ParserUtils {
    public static void parseCustomAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, AttributeCallback callback) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            String name = attribute.getLocalName();
            if ("depends-on".equals(name)) {
                builder.getBeanDefinition().setDependsOn(StringUtils.tokenizeToStringArray((String)attribute.getValue(), (String)",; "));
                continue;
            }
            if ("lazy-init".equals(name)) {
                builder.setLazyInit(Boolean.getBoolean(attribute.getValue()));
                continue;
            }
            if ("abstract".equals(name)) {
                builder.setAbstract(Boolean.parseBoolean(attribute.getValue()));
                continue;
            }
            if ("parent".equals(name)) {
                builder.setParentName(attribute.getValue());
                continue;
            }
            callback.process(element, attribute, builder, parserContext);
        }
    }

    public static interface AttributeCallback {
        public void process(Element var1, Attr var2, BeanDefinitionBuilder var3, ParserContext var4);
    }
}

