/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime;

import com.alipay.sofa.ark.spi.event.biz.BeforeBizStopEvent;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.event.EventHandler;
import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.SofaRuntimeProperties;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;

public class SofaBizUninstallEventHandler
implements EventHandler<BeforeBizStopEvent> {
    public void handleEvent(BeforeBizStopEvent event) {
        this.doUninstallBiz((Biz)event.getSource());
    }

    private void doUninstallBiz(Biz biz) {
        SofaRuntimeProperties.unRegisterProperties(biz.getBizClassLoader());
        SofaRuntimeManager sofaRuntimeManager = this.getSofaRuntimeManager(biz);
        SofaFramework.unRegisterSofaRuntimeManager(sofaRuntimeManager);
        sofaRuntimeManager.shutdown();
    }

    private SofaRuntimeManager getSofaRuntimeManager(Biz biz) {
        for (SofaRuntimeManager sofaRuntimeManager : SofaFramework.getRuntimeSet()) {
            if (!sofaRuntimeManager.getAppClassLoader().equals(biz.getBizClassLoader())) continue;
            return sofaRuntimeManager;
        }
        throw new RuntimeException("No SofaRuntimeManager Found!");
    }

    public int getPriority() {
        return 100;
    }
}

