/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.component;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.model.ComponentType;
import com.alipay.sofa.runtime.service.component.Service;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.AbstractComponent;
import com.alipay.sofa.runtime.spi.component.Implementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.HealthResult;
import com.alipay.sofa.runtime.spi.util.ComponentNameFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ServiceComponent
extends AbstractComponent {
    public static final String UNREGISTER_DELAY_MILLISECONDS = "UNREGISTER_DELAY_MILLISECONDS";
    public static final ComponentType SERVICE_COMPONENT_TYPE = new ComponentType("service");
    private Service service;
    private BindingAdapterFactory bindingAdapterFactory;
    private Map<String, Property> properties = new ConcurrentHashMap<String, Property>();

    public ServiceComponent(Implementation implementation, Service service, BindingAdapterFactory bindingAdapterFactory, SofaRuntimeContext sofaRuntimeContext) {
        this.componentName = ComponentNameFactory.createComponentName(SERVICE_COMPONENT_TYPE, service.getInterfaceType(), service.getUniqueId());
        this.implementation = implementation;
        this.service = service;
        this.bindingAdapterFactory = bindingAdapterFactory;
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    @Override
    public ComponentType getType() {
        return SERVICE_COMPONENT_TYPE;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean resolve() {
        this.resolveBinding();
        return super.resolve();
    }

    private void resolveBinding() {
        Object target = this.service.getTarget();
        if (target == null) {
            throw new ServiceRuntimeException("Must contains the target object whiling registering Service.");
        }
        if (this.service.hasBinding()) {
            Set bindings = this.service.getBindings();
            boolean allPassed = true;
            for (Binding binding : bindings) {
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException("Can't find BindingAdapter of type " + binding.getBindingType() + " while registering service " + this.service + ".");
                }
                SofaLogger.info(" <<PreOut Binding [{0}] Begins - {1}.", binding.getBindingType(), this.service);
                try {
                    bindingAdapter.preOutBinding(this.service, binding, target, this.getContext());
                }
                catch (Throwable t) {
                    allPassed = false;
                    SofaLogger.error(t, " <<PreOut Binding [{0}] for [{1}] occur exception.", binding.getBindingType(), this.service);
                    continue;
                }
                SofaLogger.info(" <<PreOut Binding [{0}] Ends - {1}.", binding.getBindingType(), this.service);
            }
            if (!allPassed) {
                throw new ServiceRuntimeException(" <<PreOut Binding [" + this.service + "] occur exception.");
            }
        }
    }

    @Override
    public void activate() throws ServiceRuntimeException {
        this.activateBinding();
        super.activate();
    }

    private void activateBinding() {
        Object target = this.service.getTarget();
        if (target == null) {
            throw new ServiceRuntimeException("Must contains the target object whiling registering Service.");
        }
        if (this.service.hasBinding()) {
            boolean allPassed = true;
            Set bindings = this.service.getBindings();
            for (Binding binding : bindings) {
                Object outBindingResult;
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException("Can't find BindingAdapter of type " + binding.getBindingType() + " while registering service " + this.service + ".");
                }
                SofaLogger.info(" <<Out Binding [{0}] Begins - {1}.", binding.getBindingType(), this.service);
                try {
                    outBindingResult = bindingAdapter.outBinding(this.service, binding, target, this.getContext());
                }
                catch (Throwable t) {
                    allPassed = false;
                    SofaLogger.error(t, " <<Out binding [{0}] for [{1}] occur exception.", binding.getBindingType(), this.service);
                    continue;
                }
                if (!Boolean.FALSE.equals(outBindingResult)) {
                    SofaLogger.info(" <<Out Binding [{0}] Ends - {1}.", binding.getBindingType(), this.service);
                    continue;
                }
                binding.setHealthy(false);
                SofaLogger.info(" <<Out Binding [{0}] Fails, Don't publish service - {1}.", binding.getBindingType(), this.service);
            }
            if (!allPassed) {
                throw new ServiceRuntimeException(" <<Out Binding [" + this.service + "] occur exception.");
            }
        }
        SofaLogger.info("Register Service - {0}", this.service);
    }

    @Override
    public void deactivate() throws ServiceRuntimeException {
        Object target = this.service.getTarget();
        if (target == null) {
            throw new ServiceRuntimeException("Must contains the target object whiling registering Service.");
        }
        if (this.service.hasBinding()) {
            boolean allPassed = true;
            Set bindings = this.service.getBindings();
            for (Binding binding : bindings) {
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException("Can't find BindingAdapter of type " + binding.getBindingType() + " while deactivate service " + this.service + ".");
                }
                SofaLogger.info(" <<Pre un-out Binding [{0}] Begins - {1}.", binding.getBindingType(), this.service);
                try {
                    bindingAdapter.preUnoutBinding(this.service, binding, target, this.getContext());
                }
                catch (Throwable t) {
                    allPassed = false;
                    SofaLogger.error(t, " <<Pre un-out Binding [{0}] for [{1}] occur exception.", binding.getBindingType(), this.service);
                    continue;
                }
                SofaLogger.info(" <<Pre un-out Binding [{0}] Ends - {1}.", binding.getBindingType(), this.service);
            }
            if (!allPassed) {
                throw new ServiceRuntimeException(" <<Pre un-out Binding [" + this.service + "] occur exception.");
            }
        }
        super.deactivate();
    }

    @Override
    public void unregister() throws ServiceRuntimeException {
        Object target;
        super.unregister();
        Property unregisterDelayMillisecondsProperty = this.properties.get(UNREGISTER_DELAY_MILLISECONDS);
        if (unregisterDelayMillisecondsProperty != null) {
            int unregisterDelayMilliseconds = unregisterDelayMillisecondsProperty.getInteger();
            try {
                TimeUnit.MILLISECONDS.sleep(unregisterDelayMilliseconds);
            }
            catch (InterruptedException e) {
                throw new ServiceRuntimeException("Unregiter component " + this.toString() + " got an error", e);
            }
        }
        if ((target = this.service.getTarget()) == null) {
            throw new ServiceRuntimeException("Must contains the target object whiling registering Service.");
        }
        if (this.service.hasBinding()) {
            boolean allPassed = true;
            Set bindings = this.service.getBindings();
            for (Binding binding : bindings) {
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException("Can't find BindingAdapter of type " + binding.getBindingType() + " while unregister service " + this.service + ".");
                }
                SofaLogger.info(" <<Post un-out Binding [{0}] Begins - {1}.", binding.getBindingType(), this.service);
                try {
                    bindingAdapter.postUnoutBinding(this.service, binding, target, this.getContext());
                }
                catch (Throwable t) {
                    allPassed = false;
                    SofaLogger.error(t, " <<Post un-out Binding [{0}] for [{1}] occur exception.", binding.getBindingType(), this.service);
                    continue;
                }
                SofaLogger.info(" <<Post un-out Binding [{0}] Ends - {1}.", binding.getBindingType(), this.service);
            }
            if (!allPassed) {
                throw new ServiceRuntimeException(" <<Post un-out Binding [" + this.service + "] occur exception.");
            }
        }
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder(super.dump());
        Set bindings = this.service.getBindings();
        for (Binding binding : bindings) {
            sb.append("\n|------>[binding]-").append(binding.dump());
        }
        return sb.toString();
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public HealthResult isHealthy() {
        if (!this.isActivated()) {
            return super.isHealthy();
        }
        HealthResult healthResult = new HealthResult(this.componentName.getRawName());
        if (this.e == null) {
            healthResult.setHealthy(true);
        } else {
            healthResult.setHealthy(false);
            healthResult.setHealthReport(this.e.getMessage());
        }
        return healthResult;
    }
}

