/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.runtime.ext.client.ExtensionClientImpl;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import com.alipay.sofa.runtime.spring.ClientFactoryBeanPostProcessor;
import com.alipay.sofa.runtime.spring.ExtensionClientBeanPostProcessor;
import com.alipay.sofa.runtime.spring.ReferenceAnnotationBeanPostProcessor;
import com.alipay.sofa.runtime.spring.RuntimeShutdownAwarePostProcessor;
import com.alipay.sofa.runtime.spring.SofaRuntimeContextAwareProcessor;
import com.alipay.sofa.runtime.spring.bean.SofaParameterNameDiscoverer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class RuntimeContextBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private BindingAdapterFactory bindingAdapterFactory;
    private BindingConverterFactory bindingConverterFactory;
    private SofaRuntimeContext sofaRuntimeContext;
    private ApplicationContext applicationContext;

    public RuntimeContextBeanFactoryPostProcessor(BindingAdapterFactory bindingAdapterFactory, BindingConverterFactory bindingConverterFactory, SofaRuntimeContext sofaRuntimeContext) {
        this.bindingAdapterFactory = bindingAdapterFactory;
        this.bindingConverterFactory = bindingConverterFactory;
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new SofaRuntimeContextAwareProcessor(this.sofaRuntimeContext));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ClientFactoryBeanPostProcessor(this.sofaRuntimeContext.getClientFactory()));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ExtensionClientBeanPostProcessor(new ExtensionClientImpl(this.sofaRuntimeContext)));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ReferenceAnnotationBeanPostProcessor(this.applicationContext, this.sofaRuntimeContext, this.bindingAdapterFactory, this.bindingConverterFactory));
        RuntimeShutdownAwarePostProcessor runtimeShutdownAwarePostProcessor = new RuntimeShutdownAwarePostProcessor(this.sofaRuntimeContext.getSofaRuntimeManager());
        beanFactory.addBeanPostProcessor((BeanPostProcessor)runtimeShutdownAwarePostProcessor);
        beanFactory.registerSingleton(RuntimeShutdownAwarePostProcessor.class.getCanonicalName(), (Object)runtimeShutdownAwarePostProcessor);
        if (beanFactory instanceof AbstractAutowireCapableBeanFactory) {
            ((AbstractAutowireCapableBeanFactory)beanFactory).setParameterNameDiscoverer((ParameterNameDiscoverer)new SofaParameterNameDiscoverer(this.applicationContext.getEnvironment()));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

