/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.async;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AsyncInitBeanHolder {
    private static final ConcurrentMap<String, Map<String, String>> asyncBeanInfos = new ConcurrentHashMap<String, Map<String, String>>();

    public static void registerAsyncInitBean(String moduleName, String beanId, String methodName) {
        if (moduleName == null || beanId == null || methodName == null) {
            return;
        }
        Map asyncBeanInfosInModule = (Map)asyncBeanInfos.get(moduleName);
        if (asyncBeanInfosInModule == null) {
            asyncBeanInfos.putIfAbsent(moduleName, new ConcurrentHashMap());
            asyncBeanInfosInModule = (Map)asyncBeanInfos.get(moduleName);
        }
        asyncBeanInfosInModule.put(beanId, methodName);
    }

    public static String getAsyncInitMethodName(String moduleName, String beanId) {
        Map asyncBeanInfosInModule = moduleName == null ? null : (Map)asyncBeanInfos.get(moduleName);
        return beanId == null || asyncBeanInfosInModule == null ? null : (String)asyncBeanInfosInModule.get(beanId);
    }
}

