/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.context;

import com.alipay.sofa.boot.context.ContextRefreshInterceptor;
import com.alipay.sofa.boot.context.SofaGenericApplicationContext;
import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.context.SpringContextComponent;
import com.alipay.sofa.runtime.context.SpringContextImplementation;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.ComponentNameFactory;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import java.util.Collection;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;

public class ComponentContextRefreshInterceptor
implements ContextRefreshInterceptor {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(ComponentContextRefreshInterceptor.class);
    private final ComponentManager componentManager;
    private final SofaRuntimeContext sofaRuntimeContext;

    public ComponentContextRefreshInterceptor(SofaRuntimeManager sofaRuntimeManager) {
        this.componentManager = sofaRuntimeManager.getComponentManager();
        this.sofaRuntimeContext = sofaRuntimeManager.getSofaRuntimeContext();
    }

    public void afterRefresh(SofaGenericApplicationContext context, Throwable throwable) {
        if (throwable == null) {
            ComponentName componentName = ComponentNameFactory.createComponentName(SpringContextComponent.SPRING_COMPONENT_TYPE, context.getId());
            SpringContextImplementation implementation = new SpringContextImplementation((ApplicationContext)context);
            SpringContextComponent componentInfo = new SpringContextComponent(componentName, implementation, this.sofaRuntimeContext);
            this.componentManager.register(componentInfo);
        } else {
            Collection<ComponentInfo> componentInfos = this.componentManager.getComponentInfosByApplicationContext((ApplicationContext)context);
            for (ComponentInfo componentInfo : componentInfos) {
                try {
                    this.componentManager.unregister(componentInfo);
                }
                catch (ServiceRuntimeException e) {
                    LOGGER.error(ErrorCode.convert((String)"01-03001", (Object[])new Object[]{componentInfo.getName()}), (Throwable)e);
                }
            }
        }
    }
}

