/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.proxy;

import com.alipay.sofa.boot.context.processor.SingletonSofaPostProcessor;
import com.alipay.sofa.runtime.proxy.SofaProxyFactoryBean;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.PriorityOrdered;

@SingletonSofaPostProcessor
public class ProxyBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
PriorityOrdered {
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        boolean updateProxyBean = false;
        for (String beanName : registry.getBeanDefinitionNames()) {
            String transformedBeanName = BeanFactoryUtils.transformedBeanName((String)beanName);
            if (!registry.containsBeanDefinition(transformedBeanName)) continue;
            BeanDefinition beanDefinition = registry.getBeanDefinition(transformedBeanName);
            if (!ProxyFactoryBean.class.getName().equals(beanDefinition.getBeanClassName())) continue;
            beanDefinition.setBeanClassName(SofaProxyFactoryBean.class.getName());
            Object proxyInterfaces = beanDefinition.getPropertyValues().get("proxyInterfaces");
            if (proxyInterfaces == null) {
                proxyInterfaces = beanDefinition.getPropertyValues().get("interfaces");
            }
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, proxyInterfaces);
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, beanDefinition.getPropertyValues().get("targetName"));
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(2, beanDefinition.getPropertyValues().get("targetClass"));
            if (registry instanceof ConfigurableListableBeanFactory) {
                beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(3, (Object)registry);
            }
            updateProxyBean = true;
        }
        if (updateProxyBean && registry instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)registry).clearMetadataCache();
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

