/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.component;

import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.model.ComponentType;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.binding.JvmServiceSupport;
import com.alipay.sofa.runtime.service.component.Reference;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.service.helper.ReferenceRegisterHelper;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.AbstractComponent;
import com.alipay.sofa.runtime.spi.component.ComponentDefinitionInfo;
import com.alipay.sofa.runtime.spi.component.ComponentNameFactory;
import com.alipay.sofa.runtime.spi.component.DefaultImplementation;
import com.alipay.sofa.runtime.spi.component.Implementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.HealthResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class ReferenceComponent
extends AbstractComponent {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(ReferenceComponent.class);
    public static final ComponentType REFERENCE_COMPONENT_TYPE = new ComponentType("reference");
    private final BindingAdapterFactory bindingAdapterFactory;
    private final Reference reference;
    private final CountDownLatch latch = new CountDownLatch(1);

    public ReferenceComponent(Reference reference, Implementation implementation, BindingAdapterFactory bindingAdapterFactory, SofaRuntimeContext sofaRuntimeContext) {
        this.componentName = ComponentNameFactory.createComponentName(REFERENCE_COMPONENT_TYPE, reference.getInterfaceType(), reference.getUniqueId() + "#" + ReferenceRegisterHelper.generateBindingHashCode(reference));
        this.reference = reference;
        this.implementation = implementation;
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.bindingAdapterFactory = bindingAdapterFactory;
    }

    @Override
    public ComponentType getType() {
        return REFERENCE_COMPONENT_TYPE;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public HealthResult isHealthy() {
        Object serviceTarget;
        HealthResult result = new HealthResult(this.componentName.getRawName());
        ArrayList<HealthResult> bindingHealth = new ArrayList<HealthResult>();
        JvmBinding jvmBinding = null;
        HealthResult jvmBindingHealthResult = null;
        if (this.reference.hasBinding()) {
            for (Binding binding : this.reference.getBindings()) {
                bindingHealth.add(binding.healthCheck());
                if (!JvmBinding.JVM_BINDING_TYPE.equals(binding.getBindingType())) continue;
                jvmBinding = (JvmBinding)binding;
                jvmBindingHealthResult = (HealthResult)bindingHealth.get(bindingHealth.size() - 1);
            }
        }
        if (jvmBinding != null && this.reference.isRequired() && !this.isSkipReferenceHealthCheck(this.sofaRuntimeContext.getProperties()) && (serviceTarget = this.getServiceTarget()) == null && !jvmBinding.hasBackupProxy()) {
            Object object;
            Property sourceProperty;
            jvmBindingHealthResult.setHealthy(false);
            StringBuilder healthReport = new StringBuilder(64);
            healthReport.append("can not find corresponding jvm service");
            if (this.sofaRuntimeContext.getProperties().isReferenceHealthCheckMoreDetailEnable() && (sourceProperty = this.getProperties().get("source")) != null && sourceProperty.getValue() != null && (object = sourceProperty.getValue()) instanceof ComponentDefinitionInfo) {
                ComponentDefinitionInfo definitionInfo = (ComponentDefinitionInfo)object;
                healthReport.append(".");
                healthReport.append(String.format("Which first declared through:%s beanId:%s,beanClassName:%s,location:%s", new Object[]{definitionInfo.getInterfaceMode(), definitionInfo.info("beanId"), definitionInfo.info("beanClassName"), definitionInfo.info("location")}));
            }
            jvmBindingHealthResult.setHealthReport(healthReport.toString());
        }
        ArrayList<HealthResult> failedBindingHealth = new ArrayList<HealthResult>();
        for (HealthResult healthResult : bindingHealth) {
            if (healthResult == null || healthResult.isHealthy()) continue;
            failedBindingHealth.add(healthResult);
        }
        result.setHealthy(failedBindingHealth.size() == 0);
        Object report = this.aggregateBindingHealth(this.reference.getBindings());
        if (this.e != null) {
            report = (String)report + " [" + this.e.getMessage() + "]";
            result.setHealthy(false);
        }
        result.setHealthReport((String)report);
        return result;
    }

    @Override
    public void activate() throws ServiceRuntimeException {
        if (this.reference.hasBinding()) {
            Binding candidate = null;
            Set bindings = this.reference.getBindings();
            if (bindings.size() == 1) {
                candidate = (Binding)bindings.iterator().next();
            } else if (bindings.size() > 1) {
                Object backupProxy = null;
                for (Binding binding : bindings) {
                    if (JvmBinding.JVM_BINDING_TYPE.getType().equals(binding.getName())) {
                        candidate = binding;
                        continue;
                    }
                    backupProxy = this.createProxy(this.reference, binding);
                }
                if (candidate != null) {
                    ((JvmBinding)candidate).setBackupProxy(backupProxy);
                }
            }
            Object proxy = null;
            if (candidate != null) {
                proxy = this.createProxy(this.reference, candidate);
            }
            this.implementation = new DefaultImplementation();
            this.implementation.setTarget(proxy);
        }
        super.activate();
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() throws ServiceRuntimeException {
        super.unregister();
        if (this.reference.hasBinding()) {
            for (Binding binding : this.reference.getBindings()) {
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00100", (Object[])new Object[]{binding.getBindingType(), this.reference}));
                }
                LOGGER.info(" >>Un-in Binding [{}] Begins - {}.", (Object)binding.getBindingType(), (Object)this.reference);
                try {
                    bindingAdapter.unInBinding(this.reference, binding, this.sofaRuntimeContext);
                }
                finally {
                    LOGGER.info(" >>Un-in Binding [{}] Ends - {}.", (Object)binding.getBindingType(), (Object)this.reference);
                }
            }
        }
    }

    @Override
    public void exception(Exception e) throws ServiceRuntimeException {
        super.exception(e);
        this.latch.countDown();
    }

    @Override
    public Implementation getImplementation() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00101"), e);
        }
        if (this.e != null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00102"), this.e);
        }
        return super.getImplementation();
    }

    public Reference getReference() {
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createProxy(Reference reference, Binding binding) {
        Object proxy;
        BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
        if (bindingAdapter == null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00100", (Object[])new Object[]{binding.getBindingType(), reference}));
        }
        LOGGER.info(" >>In Binding [{}] Begins - {}.", (Object)binding.getBindingType(), (Object)reference);
        try {
            proxy = bindingAdapter.inBinding(reference, binding, this.sofaRuntimeContext);
        }
        finally {
            LOGGER.info(" >>In Binding [{}] Ends - {}.", (Object)binding.getBindingType(), (Object)reference);
        }
        return proxy;
    }

    private Object getServiceTarget() {
        Object serviceTarget = null;
        ServiceComponent serviceComponent = JvmServiceSupport.foundServiceComponent(this.sofaRuntimeContext.getComponentManager(), this.reference);
        if (serviceComponent != null) {
            serviceTarget = serviceComponent.getImplementation().getTarget();
        }
        if (serviceTarget == null) {
            serviceTarget = this.sofaRuntimeContext.getServiceProxyManager().getDynamicServiceProxy(this.reference, this.sofaRuntimeContext.getAppClassLoader());
        }
        return serviceTarget;
    }

    private boolean isSkipReferenceHealthCheck(SofaRuntimeContext.Properties properties) {
        if (properties.isSkipJvmReferenceHealthCheck()) {
            return true;
        }
        List<String> skipCheckList = properties.getSkipJvmReferenceHealthCheckList();
        Object interfaceType = this.reference.getInterfaceType().getName();
        String uniqueId = this.reference.getUniqueId();
        if (StringUtils.hasText((String)uniqueId)) {
            interfaceType = (String)interfaceType + ":" + uniqueId;
        }
        return skipCheckList.contains(interfaceType);
    }
}

