/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spi.component;

import com.alipay.sofa.runtime.api.client.ClientFactory;
import com.alipay.sofa.runtime.filter.JvmFilterHolder;
import com.alipay.sofa.runtime.spi.client.ClientFactoryInternal;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.service.DefaultDynamicServiceProxyManager;
import com.alipay.sofa.runtime.spi.service.DynamicServiceProxyManager;
import java.util.ArrayList;
import java.util.List;

public class SofaRuntimeContext {
    private final ComponentManager componentManager;
    private final SofaRuntimeManager sofaRuntimeManager;
    private final ClientFactoryInternal clientFactory;
    private final Properties properties;
    private final JvmFilterHolder jvmFilterHolder;
    private DynamicServiceProxyManager serviceProxyManager;

    public SofaRuntimeContext(SofaRuntimeManager sofaRuntimeManager) {
        this.sofaRuntimeManager = sofaRuntimeManager;
        this.componentManager = sofaRuntimeManager.getComponentManager();
        this.clientFactory = sofaRuntimeManager.getClientFactoryInternal();
        this.properties = new Properties();
        this.jvmFilterHolder = new JvmFilterHolder();
        this.serviceProxyManager = new DefaultDynamicServiceProxyManager();
    }

    public String getAppName() {
        return this.sofaRuntimeManager.getAppName();
    }

    public ClassLoader getAppClassLoader() {
        return this.sofaRuntimeManager.getAppClassLoader();
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public ClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public SofaRuntimeManager getSofaRuntimeManager() {
        return this.sofaRuntimeManager;
    }

    public DynamicServiceProxyManager getServiceProxyManager() {
        return this.serviceProxyManager;
    }

    public void setServiceProxyManager(DynamicServiceProxyManager serviceProxyManager) {
        this.serviceProxyManager = serviceProxyManager;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public JvmFilterHolder getJvmFilterHolder() {
        return this.jvmFilterHolder;
    }

    public static class Properties {
        private boolean skipJvmReferenceHealthCheck = false;
        private boolean skipExtensionHealthCheck = false;
        private boolean disableJvmFirst = false;
        private boolean extensionFailureInsulating = false;
        private boolean skipAllComponentShutdown = false;
        private boolean skipCommonComponentShutdown = false;
        private boolean jvmFilterEnable = false;
        private boolean serviceInterfaceTypeCheck = false;
        private List<String> skipJvmReferenceHealthCheckList = new ArrayList<String>();
        private boolean referenceHealthCheckMoreDetailEnable = false;
        private boolean serviceCanBeDuplicate = true;

        public boolean isSkipJvmReferenceHealthCheck() {
            return this.skipJvmReferenceHealthCheck;
        }

        public void setSkipJvmReferenceHealthCheck(boolean skipJvmReferenceHealthCheck) {
            this.skipJvmReferenceHealthCheck = skipJvmReferenceHealthCheck;
        }

        public boolean isSkipExtensionHealthCheck() {
            return this.skipExtensionHealthCheck;
        }

        public void setSkipExtensionHealthCheck(boolean skipExtensionHealthCheck) {
            this.skipExtensionHealthCheck = skipExtensionHealthCheck;
        }

        public boolean isDisableJvmFirst() {
            return this.disableJvmFirst;
        }

        public void setDisableJvmFirst(boolean disableJvmFirst) {
            this.disableJvmFirst = disableJvmFirst;
        }

        public boolean isExtensionFailureInsulating() {
            return this.extensionFailureInsulating;
        }

        public void setExtensionFailureInsulating(boolean extensionFailureInsulating) {
            this.extensionFailureInsulating = extensionFailureInsulating;
        }

        public boolean isSkipAllComponentShutdown() {
            return this.skipAllComponentShutdown;
        }

        public void setSkipAllComponentShutdown(boolean skipAllComponentShutdown) {
            this.skipAllComponentShutdown = skipAllComponentShutdown;
        }

        public boolean isSkipCommonComponentShutdown() {
            return this.skipCommonComponentShutdown;
        }

        public void setSkipCommonComponentShutdown(boolean skipCommonComponentShutdown) {
            this.skipCommonComponentShutdown = skipCommonComponentShutdown;
        }

        public boolean isJvmFilterEnable() {
            return this.jvmFilterEnable;
        }

        public void setJvmFilterEnable(boolean jvmFilterEnable) {
            this.jvmFilterEnable = jvmFilterEnable;
        }

        public boolean isServiceInterfaceTypeCheck() {
            return this.serviceInterfaceTypeCheck;
        }

        public void setServiceInterfaceTypeCheck(boolean serviceInterfaceTypeCheck) {
            this.serviceInterfaceTypeCheck = serviceInterfaceTypeCheck;
        }

        public List<String> getSkipJvmReferenceHealthCheckList() {
            return this.skipJvmReferenceHealthCheckList;
        }

        public void setSkipJvmReferenceHealthCheckList(List<String> skipJvmReferenceHealthCheckList) {
            this.skipJvmReferenceHealthCheckList = skipJvmReferenceHealthCheckList;
        }

        public boolean isReferenceHealthCheckMoreDetailEnable() {
            return this.referenceHealthCheckMoreDetailEnable;
        }

        public void setReferenceHealthCheckMoreDetailEnable(boolean referenceHealthCheckMoreDetailEnable) {
            this.referenceHealthCheckMoreDetailEnable = referenceHealthCheckMoreDetailEnable;
        }

        public boolean isServiceCanBeDuplicate() {
            return this.serviceCanBeDuplicate;
        }

        public void setServiceCanBeDuplicate(boolean serviceCanBeDuplicate) {
            this.serviceCanBeDuplicate = serviceCanBeDuplicate;
        }
    }
}

