/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.boot.annotation.AnnotationWrapper;
import com.alipay.sofa.boot.annotation.DefaultPlaceHolderBinder;
import com.alipay.sofa.boot.annotation.PlaceHolderBinder;
import com.alipay.sofa.boot.context.processor.SingletonSofaPostProcessor;
import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.boot.util.BeanDefinitionUtil;
import com.alipay.sofa.runtime.api.annotation.SofaAsyncInit;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@SingletonSofaPostProcessor
public class AsyncInitBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(AsyncInitBeanFactoryPostProcessor.class);
    private AnnotationWrapper<SofaAsyncInit> annotationWrapper;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Arrays.stream(beanFactory.getBeanDefinitionNames()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(arg_0))).forEach(this::scanAsyncInitBeanDefinition);
    }

    private void scanAsyncInitBeanDefinition(String beanId, BeanDefinition beanDefinition) {
        if (BeanDefinitionUtil.isFromConfigurationSource((BeanDefinition)beanDefinition)) {
            this.scanAsyncInitBeanDefinitionOnMethod(beanId, (AnnotatedBeanDefinition)beanDefinition);
        } else {
            Class beanClassType = BeanDefinitionUtil.resolveBeanClassType((BeanDefinition)beanDefinition);
            if (beanClassType == null) {
                return;
            }
            this.scanAsyncInitBeanDefinitionOnClass(beanClassType, beanDefinition);
        }
    }

    private void scanAsyncInitBeanDefinitionOnMethod(String beanId, AnnotatedBeanDefinition beanDefinition) {
        Class declaringClass;
        Class returnType;
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        MethodMetadata methodMetadata = beanDefinition.getFactoryMethodMetadata();
        try {
            returnType = ClassUtils.forName((String)methodMetadata.getReturnTypeName(), null);
            declaringClass = ClassUtils.forName((String)methodMetadata.getDeclaringClassName(), null);
        }
        catch (Throwable throwable) {
            LOGGER.error(ErrorCode.convert((String)"01-02001", (Object[])new Object[]{beanId}), throwable);
            return;
        }
        if (methodMetadata instanceof StandardMethodMetadata) {
            candidateMethods.add(((StandardMethodMetadata)methodMetadata).getIntrospectedMethod());
        } else {
            for (Method m : declaringClass.getDeclaredMethods()) {
                if (!m.getName().equals(methodMetadata.getMethodName()) || !m.getReturnType().getTypeName().equals(methodMetadata.getReturnTypeName()) || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, Bean.class)) continue;
                Bean bean = m.getAnnotation(Bean.class);
                HashSet<String> beanNames = new HashSet<String>();
                beanNames.add(m.getName());
                if (bean != null) {
                    beanNames.addAll(Arrays.asList(bean.name()));
                    beanNames.addAll(Arrays.asList(bean.value()));
                }
                if (!beanNames.contains(beanId)) continue;
                candidateMethods.add(m);
            }
        }
        if (candidateMethods.size() == 1) {
            SofaAsyncInit sofaAsyncInitAnnotation = ((Method)candidateMethods.get(0)).getAnnotation(SofaAsyncInit.class);
            if (sofaAsyncInitAnnotation == null) {
                sofaAsyncInitAnnotation = returnType.getAnnotation(SofaAsyncInit.class);
            }
            this.registerAsyncInitBean(sofaAsyncInitAnnotation, (BeanDefinition)beanDefinition);
        } else if (candidateMethods.size() > 1) {
            for (Method m : candidateMethods) {
                if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, SofaAsyncInit.class) && !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType, SofaAsyncInit.class)) continue;
                throw new FatalBeanException(ErrorCode.convert((String)"01-02002", (Object[])new Object[]{declaringClass.getCanonicalName()}));
            }
        }
    }

    private void scanAsyncInitBeanDefinitionOnClass(Class<?> beanClass, BeanDefinition beanDefinition) {
        SofaAsyncInit sofaAsyncInitAnnotation = (SofaAsyncInit)AnnotationUtils.findAnnotation(beanClass, SofaAsyncInit.class);
        this.registerAsyncInitBean(sofaAsyncInitAnnotation, beanDefinition);
    }

    private void registerAsyncInitBean(SofaAsyncInit sofaAsyncInitAnnotation, BeanDefinition beanDefinition) {
        if (sofaAsyncInitAnnotation == null) {
            return;
        }
        sofaAsyncInitAnnotation = (SofaAsyncInit)this.annotationWrapper.wrap((Annotation)sofaAsyncInitAnnotation);
        String initMethodName = beanDefinition.getInitMethodName();
        if (sofaAsyncInitAnnotation.value() && StringUtils.hasText((String)initMethodName)) {
            beanDefinition.setAttribute("async-init-method-name", (Object)initMethodName);
        }
    }

    public void setEnvironment(Environment environment) {
        this.annotationWrapper = AnnotationWrapper.create(SofaAsyncInit.class).withEnvironment(environment).withBinder((PlaceHolderBinder)DefaultPlaceHolderBinder.INSTANCE);
    }
}

