/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.factory;

import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.binding.JvmBindingParam;
import com.alipay.sofa.runtime.service.component.Reference;
import com.alipay.sofa.runtime.service.component.impl.ReferenceImpl;
import com.alipay.sofa.runtime.service.helper.ReferenceRegisterHelper;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.component.ComponentDefinitionInfo;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spring.factory.AbstractContractFactoryBean;
import org.springframework.util.Assert;

public class ReferenceFactoryBean
extends AbstractContractFactoryBean {
    protected Object proxy;
    protected boolean jvmFirst = true;
    protected String loadBalance;
    protected boolean required = true;

    public ReferenceFactoryBean() {
    }

    public ReferenceFactoryBean(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Reference reference = this.buildReference();
        Assert.isTrue((this.bindings.size() <= 1 ? 1 : 0) != 0, (String)"Found more than one binding in <sofa:reference/>, <sofa:reference/> can only have one binding.");
        if (this.bindings.size() == 0) {
            JvmBindingParam jvmBindingParam = new JvmBindingParam();
            jvmBindingParam.setSerialize(false);
            this.bindings.add(new JvmBinding().setJvmBindingParam(jvmBindingParam));
        }
        reference.addBinding((Binding)this.bindings.get(0));
        ComponentDefinitionInfo definitionInfo = new ComponentDefinitionInfo();
        definitionInfo.setInterfaceMode(this.apiType ? InterfaceMode.api : InterfaceMode.spring);
        definitionInfo.putInfo("beanId", this.beanId);
        this.proxy = ReferenceRegisterHelper.registerReference(reference, this.bindingAdapterFactory, this.sofaRuntimeContext, this.applicationContext, definitionInfo);
    }

    @Override
    protected void setProperties(BindingConverterContext bindingConverterContext) {
        bindingConverterContext.setLoadBalance(this.loadBalance);
    }

    protected Reference buildReference() {
        ReferenceImpl reference = new ReferenceImpl(this.uniqueId, this.getInterfaceClass(), InterfaceMode.spring, this.jvmFirst);
        reference.setRequired(this.required);
        return reference;
    }

    public Object getObject() throws Exception {
        return this.proxy;
    }

    public Class<?> getObjectType() {
        try {
            Class<?> type = this.getInterfaceClass();
            return type != null ? type : ReferenceFactoryBean.class;
        }
        catch (Throwable t) {
            return ReferenceFactoryBean.class;
        }
    }

    @Override
    protected boolean isInBinding() {
        return true;
    }

    public void setJvmFirst(boolean jvmFirst) {
        this.jvmFirst = jvmFirst;
    }

    public String getLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(String loadBalance) {
        this.loadBalance = loadBalance;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean getRequired() {
        return this.required;
    }
}

