/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.arklet.springboot.starter.health;

import com.alipay.sofa.serverless.arklet.core.ArkletComponentRegistry;
import com.alipay.sofa.serverless.arklet.core.health.indicator.Indicator;
import com.alipay.sofa.serverless.arklet.springboot.starter.health.endpoint.ArkHealthCodeEndpoint;
import com.alipay.sofa.serverless.arklet.springboot.starter.health.endpoint.ArkHealthEndpoint;
import com.alipay.sofa.serverless.arklet.springboot.starter.health.extension.indicator.MasterBizHealthIndicator;
import com.alipay.sofa.serverless.common.environment.ConditionalOnMasterBiz;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMasterBiz
public class HealthAutoConfiguration
implements ApplicationContextAware {
    private ApplicationContext context;

    @Bean
    public void initEndpoint() {
        WebEndpointProperties webEndpointProperties = (WebEndpointProperties)this.context.getBean(WebEndpointProperties.class);
        WebEndpointProperties.Exposure exposure = webEndpointProperties.getExposure();
        Set includePath = exposure.getInclude();
        includePath.add("*");
        webEndpointProperties.getExposure().setInclude(includePath);
        webEndpointProperties.setBasePath("/");
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public ArkHealthEndpoint arkHealthEndpoint() {
        return new ArkHealthEndpoint();
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public ArkHealthCodeEndpoint arkHealthCodeEndpoint() {
        return new ArkHealthCodeEndpoint();
    }

    @Bean
    public MasterBizHealthIndicator masterBizHealthIndicator() {
        MasterBizHealthIndicator masterBizHealthIndicator = new MasterBizHealthIndicator();
        masterBizHealthIndicator.setApplicationAvailability((ApplicationAvailability)this.context.getBean(ApplicationAvailability.class));
        ArkletComponentRegistry.getHealthServiceInstance().registerIndicator((Indicator)masterBizHealthIndicator);
        return masterBizHealthIndicator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

