/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.arklet.springboot.starter.health.endpoint;

import com.alipay.sofa.serverless.arklet.core.ArkletComponentRegistry;
import com.alipay.sofa.serverless.arklet.core.health.HealthService;
import com.alipay.sofa.serverless.arklet.core.health.model.Health;
import com.alipay.sofa.serverless.arklet.springboot.starter.health.endpoint.model.EndpointResponseCode;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="arkHealthCode")
public class ArkHealthCodeEndpoint {
    private final HealthService healthService = ArkletComponentRegistry.getHealthServiceInstance();

    @ReadOperation
    public int healthCode() {
        return ArkHealthCodeEndpoint.ofCode(new Health.HealthBuilder().init().putAllHealthData(this.healthService.getHealth()).putAllHealthData(this.healthService.queryModuleInfo()).build());
    }

    @ReadOperation
    public int getModuleInfoHealthCode1(@Selector String moduleType) {
        return ArkHealthCodeEndpoint.ofCode(this.healthService.queryModuleInfo(moduleType, null, null));
    }

    @ReadOperation
    public int getModuleInfoHealthCode2(@Selector String moduleType, @Selector String name, @Selector String version) {
        return ArkHealthCodeEndpoint.ofCode(this.healthService.queryModuleInfo(moduleType, name, version));
    }

    public static int ofCode(Health health) {
        int endpointCode = health.containsError("endpointError") ? EndpointResponseCode.ENDPOINT_NOT_FOUND.getCode() : (health.containsError("error") ? EndpointResponseCode.ENDPOINT_PROCESS_INTERNAL_ERROR.getCode() : (health.containsUnhealthy("ACCEPTING_TRAFFIC") ? EndpointResponseCode.UNHEALTHY.getCode() : EndpointResponseCode.HEALTHY.getCode()));
        return endpointCode;
    }
}

