/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.arklet.springboot.starter.health.endpoint;

import com.alipay.sofa.serverless.arklet.core.ArkletComponentRegistry;
import com.alipay.sofa.serverless.arklet.core.health.HealthService;
import com.alipay.sofa.serverless.arklet.core.health.model.Health;
import com.alipay.sofa.serverless.arklet.springboot.starter.health.endpoint.model.EndpointResponse;
import com.alipay.sofa.serverless.arklet.springboot.starter.health.endpoint.model.EndpointResponseCode;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="arkHealth")
public class ArkHealthEndpoint {
    private final HealthService healthService = ArkletComponentRegistry.getHealthServiceInstance();

    @ReadOperation
    public EndpointResponse<Map<String, Object>> getHealth() {
        return ArkHealthEndpoint.ofResponse(new Health.HealthBuilder().init().putAllHealthData(this.healthService.getHealth()).putAllHealthData(this.healthService.queryModuleInfo()).build());
    }

    @ReadOperation
    public EndpointResponse<Map<String, Object>> getModuleInfo1(@Selector String moduleType) {
        return ArkHealthEndpoint.ofResponse(this.healthService.queryModuleInfo(moduleType, null, null));
    }

    @ReadOperation
    public EndpointResponse<Map<String, Object>> getModuleInfo2(@Selector String moduleType, @Selector String name, @Selector String version) {
        return ArkHealthEndpoint.ofResponse(this.healthService.queryModuleInfo(moduleType, name, version));
    }

    private static EndpointResponse<Map<String, Object>> ofResponse(Health health) {
        Map healthData = health.getHealthData();
        EndpointResponse<Map<String, Object>> endpointResponse = health.containsError("endpointError") ? EndpointResponse.ofFailed(EndpointResponseCode.ENDPOINT_NOT_FOUND, healthData) : (health.containsError("error") ? EndpointResponse.ofFailed(EndpointResponseCode.ENDPOINT_PROCESS_INTERNAL_ERROR, healthData) : (health.containsUnhealthy("ACCEPTING_TRAFFIC") ? EndpointResponse.ofFailed(EndpointResponseCode.UNHEALTHY, healthData) : EndpointResponse.ofSuccess(healthData)));
        return endpointResponse;
    }
}

