/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.arklet.springboot.starter.health.endpoint.model;

import java.util.Arrays;
import java.util.HashSet;

public enum EndpointResponseCode {
    HEALTHY(200),
    UNHEALTHY(400),
    ENDPOINT_NOT_FOUND(404),
    ENDPOINT_PROCESS_INTERNAL_ERROR(500);

    private final int code;

    private EndpointResponseCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static EndpointResponseCode getEndpointResponseCode(int code) {
        HashSet<EndpointResponseCode> codes = new HashSet<EndpointResponseCode>(Arrays.asList(EndpointResponseCode.values()));
        EndpointResponseCode endpointResponseCode = null;
        for (EndpointResponseCode codeType : codes) {
            if (codeType.getCode() != code) continue;
            endpointResponseCode = codeType;
        }
        return endpointResponseCode;
    }

    public static boolean existCode(int code) {
        HashSet<EndpointResponseCode> codes = new HashSet<EndpointResponseCode>(Arrays.asList(EndpointResponseCode.values()));
        boolean exists = false;
        for (EndpointResponseCode codeType : codes) {
            exists |= codeType.getCode() == code;
        }
        return exists;
    }
}

