/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.common;

import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.serverless.common.exception.BizRuntimeException;
import com.alipay.sofa.serverless.common.service.ServiceProxyCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class BizRuntimeContext {
    private String bizName;
    private ClassLoader appClassLoader;
    private ApplicationContext rootApplicationContext;
    private Map<ClassLoader, Map<String, ServiceProxyCache>> serviceProxyCaches = new ConcurrentHashMap<ClassLoader, Map<String, ServiceProxyCache>>();

    public String getBizName() {
        return this.bizName;
    }

    public void setBizName(String bizName) {
        this.bizName = bizName;
    }

    public ClassLoader getAppClassLoader() {
        return this.appClassLoader;
    }

    public void setAppClassLoader(ClassLoader appClassLoader) {
        this.appClassLoader = appClassLoader;
    }

    public ApplicationContext getRootApplicationContext() {
        return this.rootApplicationContext;
    }

    public void setRootApplicationContext(ApplicationContext rootApplicationContext) {
        this.rootApplicationContext = rootApplicationContext;
    }

    public BizRuntimeContext(Biz biz) {
        this(biz, null);
    }

    public BizRuntimeContext(Biz biz, ApplicationContext applicationContext) {
        this.bizName = biz.getBizName();
        this.appClassLoader = biz.getBizClassLoader();
        this.rootApplicationContext = applicationContext;
    }

    public Map<ClassLoader, Map<String, ServiceProxyCache>> getServiceProxyCaches() {
        return this.serviceProxyCaches;
    }

    public void removeServiceProxyCaches(ClassLoader classLoader) {
        this.serviceProxyCaches.remove(classLoader);
    }

    public void shutdownContext() {
        try {
            AbstractApplicationContext applicationContext = (AbstractApplicationContext)this.rootApplicationContext;
            if (applicationContext.isActive()) {
                applicationContext.close();
            }
            this.appClassLoader = null;
        }
        catch (Throwable throwable) {
            throw new BizRuntimeException("100001", throwable);
        }
    }
}

