/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.common;

import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.serverless.common.BizRuntimeContext;
import com.alipay.sofa.serverless.common.exception.BizRuntimeException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class BizRuntimeContextRegistry {
    private static ConcurrentHashMap<ClassLoader, BizRuntimeContext> contextMap = new ConcurrentHashMap();

    public static void registerBizRuntimeManager(BizRuntimeContext bizRuntimeContext) {
        contextMap.put(bizRuntimeContext.getAppClassLoader(), bizRuntimeContext);
    }

    public static void unRegisterBizRuntimeManager(BizRuntimeContext bizRuntimeContext) {
        contextMap.remove(bizRuntimeContext.getAppClassLoader());
    }

    public static Set<BizRuntimeContext> getRuntimeSet() {
        return Collections.unmodifiableSet(new CopyOnWriteArraySet<BizRuntimeContext>(contextMap.values()));
    }

    public static ConcurrentHashMap<ClassLoader, BizRuntimeContext> getRuntimeMap() {
        return contextMap;
    }

    public static BizRuntimeContext getBizRuntimeContext(Biz biz) {
        if (BizRuntimeContextRegistry.getRuntimeMap().containsKey(biz.getBizClassLoader())) {
            return BizRuntimeContextRegistry.getRuntimeMap().get(biz.getBizClassLoader());
        }
        throw new BizRuntimeException("100002", "No BizRuntimeContext found for biz: " + biz.getBizName());
    }

    public static BizRuntimeContext getBizRuntimeContextByClassLoader(ClassLoader classLoader) {
        if (BizRuntimeContextRegistry.getRuntimeMap().containsKey(classLoader)) {
            return BizRuntimeContextRegistry.getRuntimeMap().get(classLoader);
        }
        throw new BizRuntimeException("100002", "No BizRuntimeContext found for classLoader: " + classLoader);
    }
}

