/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.common.api;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.serverless.common.service.ServiceProxyFactory;
import java.util.Map;

public class SpringServiceFinder {
    public static <T> T getBaseService(String name, Class<T> serviceType) {
        Biz masterBiz = ArkClient.getMasterBiz();
        return ServiceProxyFactory.createServiceProxy(masterBiz, name, serviceType, null);
    }

    public static <T> T getBaseService(Class<T> serviceType) {
        Biz masterBiz = ArkClient.getMasterBiz();
        return ServiceProxyFactory.createServiceProxy(masterBiz, serviceType, null);
    }

    public static <T> Map<String, T> listBaseServices(Class<T> serviceType) {
        Biz masterBiz = ArkClient.getMasterBiz();
        return ServiceProxyFactory.batchCreateServiceProxy(masterBiz, serviceType, null);
    }

    public static <T> T getModuleService(String moduleName, String moduleVersion, String name, Class<T> serviceType) {
        Biz biz = ServiceProxyFactory.determineMostSuitableBiz(moduleName, moduleVersion);
        return ServiceProxyFactory.createServiceProxy(biz, name, serviceType, null);
    }

    public static <T> T getModuleService(String moduleName, String moduleVersion, Class<T> serviceType) {
        Biz biz = ServiceProxyFactory.determineMostSuitableBiz(moduleName, moduleVersion);
        return ServiceProxyFactory.createServiceProxy(biz, serviceType, null);
    }

    public static <T> Map<String, T> listModuleServices(String moduleName, String moduleVersion, Class<T> serviceType) {
        Biz biz = ServiceProxyFactory.determineMostSuitableBiz(moduleName, moduleVersion);
        return ServiceProxyFactory.batchCreateServiceProxy(biz, serviceType, null);
    }
}

