/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.common.service;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.serverless.common.api.AutowiredFromBase;
import com.alipay.sofa.serverless.common.api.AutowiredFromBiz;
import com.alipay.sofa.serverless.common.service.ServiceProxyFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ArkAutowiredBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArkAutowiredBeanPostProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClassType = bean.getClass();
        ReflectionUtils.doWithFields(beanClassType, field -> {
            Object serviceProxy;
            block14: {
                boolean required;
                String name;
                Biz biz;
                LOGGER.info("Processing bean [{}] field [{}]", (Object)beanName, (Object)field);
                AutowiredFromBase autowiredFromBase = field.getAnnotation(AutowiredFromBase.class);
                AutowiredFromBiz autowiredFromBiz = field.getAnnotation(AutowiredFromBiz.class);
                if (autowiredFromBase != null) {
                    biz = ArkClient.getMasterBiz();
                    name = autowiredFromBase.name();
                    required = autowiredFromBase.required();
                } else if (autowiredFromBiz != null) {
                    biz = ServiceProxyFactory.determineMostSuitableBiz(autowiredFromBiz.bizName(), autowiredFromBiz.bizVersion());
                    name = autowiredFromBiz.name();
                    required = autowiredFromBiz.required();
                } else {
                    return;
                }
                ClassLoader clientClassLoader = Thread.currentThread().getContextClassLoader();
                serviceProxy = null;
                try {
                    Class<?> fieldType = field.getType();
                    if (StringUtils.hasText((String)name)) {
                        serviceProxy = ServiceProxyFactory.createServiceProxy(biz, name, fieldType, clientClassLoader);
                    }
                    if (serviceProxy == null && !Collection.class.isAssignableFrom(fieldType) && !Map.class.isAssignableFrom(fieldType)) {
                        serviceProxy = ServiceProxyFactory.createServiceProxy(biz, fieldType, clientClassLoader);
                    }
                    if (serviceProxy == null) {
                        Type genericType = field.getGenericType();
                        ParameterizedType parameterizedType = (ParameterizedType)genericType;
                        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                        Class serviceType = (Class)actualTypeArguments[0];
                        if (Map.class.isAssignableFrom(fieldType)) {
                            serviceType = (Class)actualTypeArguments[1];
                        }
                        Map serviceProxyMap = ServiceProxyFactory.batchCreateServiceProxy(biz, serviceType, clientClassLoader);
                        if (Map.class.isAssignableFrom(fieldType)) {
                            serviceProxy = serviceProxyMap;
                        }
                        if (List.class.isAssignableFrom(fieldType)) {
                            List list = (List)ArrayList.class.newInstance();
                            list.addAll(serviceProxyMap.values());
                            serviceProxy = list;
                        }
                        if (Set.class.isAssignableFrom(fieldType)) {
                            Set set = (Set)HashSet.class.newInstance();
                            set.addAll(serviceProxyMap.values());
                            serviceProxy = set;
                        }
                    }
                }
                catch (Exception e) {
                    if (!required) break block14;
                    throw new BeanCreationException(beanName, "Failed processing bean [" + beanName + "], injected object to bean [" + bean + "] field [" + field + "]", (Throwable)e);
                }
            }
            if (serviceProxy != null) {
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)bean, serviceProxy);
                LOGGER.info("Finished processing bean [{}], injected object [{}] to bean [{}] field [{}]", new Object[]{beanName, serviceProxy, bean, field});
            }
        }, field -> !Modifier.isStatic(field.getModifiers()) && (field.isAnnotationPresent(AutowiredFromBase.class) || field.isAnnotationPresent(AutowiredFromBiz.class)));
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

