/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.common.service;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.serverless.common.BizRuntimeContext;
import com.alipay.sofa.serverless.common.BizRuntimeContextRegistry;
import com.alipay.sofa.serverless.common.exception.BizRuntimeException;
import com.alipay.sofa.serverless.common.service.ServiceProxyCache;
import com.alipay.sofa.serverless.common.service.SpringServiceInvoker;
import com.alipay.sofa.serverless.common.util.ReflectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class ServiceProxyFactory {
    public static <T> T createServiceProxy(Biz biz, String name, Class<T> serviceType, ClassLoader clientClassLoader) {
        T service = ServiceProxyFactory.getService(biz, name);
        return ServiceProxyFactory.doCreateServiceProxy(biz, service, serviceType, clientClassLoader);
    }

    public static <T> T createServiceProxy(Biz biz, Class<T> serviceType, ClassLoader clientClassLoader) {
        Class<?> serviceClass = ServiceProxyFactory.checkBizStateAndGetTargetClass(biz, serviceType);
        Object service = ServiceProxyFactory.getService(biz, serviceClass);
        return ServiceProxyFactory.doCreateServiceProxy(biz, service, serviceType, clientClassLoader);
    }

    public static <T> Map<String, T> batchCreateServiceProxy(Biz biz, Class<T> serviceType, ClassLoader clientClassLoader) {
        Class<?> serviceClass = ServiceProxyFactory.checkBizStateAndGetTargetClass(biz, serviceType);
        Map<String, ?> serviceMap = ServiceProxyFactory.listService(biz, serviceClass);
        HashMap<String, T> proxyMap = new HashMap<String, T>();
        for (String beanName : serviceMap.keySet()) {
            proxyMap.put(beanName, ServiceProxyFactory.doCreateServiceProxy(biz, serviceMap.get(beanName), serviceType, clientClassLoader));
        }
        return proxyMap;
    }

    private static <T> T getService(Biz biz, String name) {
        BizRuntimeContext bizRuntimeContext = ServiceProxyFactory.checkBizStateAndGetBizRuntimeContext(biz);
        return (T)bizRuntimeContext.getRootApplicationContext().getBean(name);
    }

    private static <T> T getService(Biz biz, Class<T> serviceType) {
        BizRuntimeContext bizRuntimeContext = ServiceProxyFactory.checkBizStateAndGetBizRuntimeContext(biz);
        return (T)bizRuntimeContext.getRootApplicationContext().getBean(serviceType);
    }

    private static <T> Map<String, T> listService(Biz biz, Class<T> serviceType) {
        BizRuntimeContext bizRuntimeContext = ServiceProxyFactory.checkBizStateAndGetBizRuntimeContext(biz);
        ApplicationContext rootApplicationContext = bizRuntimeContext.getRootApplicationContext();
        if (rootApplicationContext instanceof AbstractApplicationContext) {
            ConfigurableListableBeanFactory beanFactory = ((AbstractApplicationContext)rootApplicationContext).getBeanFactory();
            return beanFactory.getBeansOfType(serviceType);
        }
        return new HashMap();
    }

    private static <T> T doCreateServiceProxy(Biz biz, Object service, Class<T> serviceType, ClassLoader clientClassLoader) {
        BizRuntimeContext bizRuntimeContext;
        Map<ClassLoader, Map<String, ServiceProxyCache>> serviceProxyCaches;
        Map cacheMap;
        if (clientClassLoader == null) {
            Class<?> callerClass = ReflectionUtils.getCallerClass(6);
            clientClassLoader = callerClass.getClassLoader();
        }
        if ((cacheMap = (serviceProxyCaches = (bizRuntimeContext = BizRuntimeContextRegistry.getBizRuntimeContextByClassLoader(clientClassLoader)).getServiceProxyCaches()).computeIfAbsent(biz.getBizClassLoader(), o -> new ConcurrentHashMap())).containsKey(service.getClass().getName())) {
            ServiceProxyCache serviceProxyCache = (ServiceProxyCache)cacheMap.get(service.getClass().getName());
            return (T)serviceProxyCache.getProxy();
        }
        SpringServiceInvoker serviceInvoker = new SpringServiceInvoker(service, biz.getBizName(), biz.getBizVersion(), biz.getIdentity(), clientClassLoader, service.getClass().getClassLoader());
        ProxyFactory factory = new ProxyFactory();
        if (serviceType.isInterface()) {
            factory.addInterface(serviceType);
        } else {
            factory.setTargetClass(serviceType);
            factory.setProxyTargetClass(true);
        }
        factory.addAdvice((Advice)serviceInvoker);
        Object proxy = factory.getProxy(clientClassLoader);
        cacheMap.put(service.getClass().getName(), new ServiceProxyCache(proxy, serviceInvoker));
        return (T)proxy;
    }

    public static Biz determineMostSuitableBiz(String moduleName, String moduleVersion) {
        Biz biz;
        if (StringUtils.isEmpty((String)moduleVersion)) {
            List bizList = ArkClient.getBizManagerService().getBiz(moduleName);
            biz = bizList.stream().filter(it -> BizState.ACTIVATED == it.getBizState()).findFirst().get();
        } else {
            biz = ArkClient.getBizManagerService().getBiz(moduleName, moduleVersion);
        }
        return biz;
    }

    private static Class<?> checkBizStateAndGetTargetClass(Biz biz, Class<?> sourceClass) {
        ServiceProxyFactory.checkBizState(biz);
        try {
            return biz.getBizClassLoader().loadClass(sourceClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new BizRuntimeException("100005", "Cannot find class " + sourceClass.getName() + " from the biz " + biz.getIdentity());
        }
    }

    private static BizRuntimeContext checkBizStateAndGetBizRuntimeContext(Biz biz) {
        ServiceProxyFactory.checkBizState(biz);
        BizRuntimeContext bizRuntimeContext = BizRuntimeContextRegistry.getBizRuntimeContext(biz);
        if (bizRuntimeContext == null) {
            throw new BizRuntimeException("100002", "biz runtime context is null");
        }
        if (bizRuntimeContext.getRootApplicationContext() == null) {
            throw new BizRuntimeException("100002", "biz spring context is null");
        }
        return bizRuntimeContext;
    }

    private static void checkBizState(Biz biz) {
        if (biz == null) {
            throw new BizRuntimeException("100003", "biz does not exist");
        }
        if (biz.getBizState() != BizState.ACTIVATED && biz.getBizState() != BizState.DEACTIVATED) {
            throw new BizRuntimeException("100004", "biz state is not valid");
        }
    }
}

