/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.common.util;

import com.alipay.sofa.serverless.common.util.LoaderUtil;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private static Method method;

    public static StackTraceElement getEquivalentStackTraceElement(int depth) {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        int i = 0;
        for (StackTraceElement element : elements) {
            if (!ReflectionUtils.isValid(element)) continue;
            if (i == depth) {
                return element;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException(Integer.toString(depth));
    }

    public static boolean isValid(StackTraceElement element) {
        if (element.isNativeMethod()) {
            return false;
        }
        String cn = element.getClassName();
        if (cn.startsWith("sun.reflect.")) {
            return false;
        }
        String mn = element.getMethodName();
        if (cn.startsWith("java.lang.reflect.") && (mn.equals("invoke") || mn.equals("newInstance"))) {
            return false;
        }
        if (cn.startsWith("jdk.internal.reflect.")) {
            return false;
        }
        if (cn.equals("java.lang.Class") && mn.equals("newInstance")) {
            return false;
        }
        return !cn.equals("java.lang.invoke.MethodHandle") || !mn.startsWith("invoke");
    }

    public static Class<?> executeReflectionLogic(int realFramesToSkip) {
        if (method == null) {
            throw new IllegalStateException("sun.reflect.Reflection initialization failure.");
        }
        try {
            return (Class)method.invoke(null, realFramesToSkip);
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurs when invoking the sun.reflect.Reflection#getCallerClass", e);
        }
    }

    public static Class<?> executeStackTraceLogic(int depth) {
        StackTraceElement element = ReflectionUtils.getEquivalentStackTraceElement(depth + 1);
        try {
            return LoaderUtil.loadClass(element.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class<?> getCallerClass(int realFramesToSkip) {
        try {
            return ReflectionUtils.executeReflectionLogic(realFramesToSkip);
        }
        catch (Exception e) {
            return ReflectionUtils.executeStackTraceLogic(realFramesToSkip);
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("sun.reflect.Reflection");
            method = clazz.getDeclaredMethod("getCallerClass", Integer.TYPE);
            method.setAccessible(true);
        }
        catch (Exception e) {
            method = null;
        }
    }
}

