/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.serverless.common.util;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerializeUtils {
    public static Object serializeTransform(Object source, ClassLoader targetClassLoader) {
        Object target;
        ClassLoader currentContextClassloader = Thread.currentThread().getContextClassLoader();
        try {
            if (targetClassLoader != null) {
                Thread.currentThread().setContextClassLoader(targetClassLoader);
            }
            SerializerFactory serializerFactory = new SerializerFactory();
            serializerFactory.setAllowNonSerializable(true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Hessian2Output h2o = new Hessian2Output((OutputStream)bos);
            h2o.setSerializerFactory(serializerFactory);
            h2o.writeObject(source);
            h2o.flush();
            byte[] content = bos.toByteArray();
            Hessian2Input h2i = new Hessian2Input((InputStream)new ByteArrayInputStream(content));
            h2i.setSerializerFactory(serializerFactory);
            target = h2i.readObject();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassloader);
        }
        return target;
    }
}

