/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.api;

import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.api.ClientResponse;
import com.alipay.sofa.ark.api.ResponseCode;
import com.alipay.sofa.ark.common.log.ArkLogger;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.BizIdentityUtils;
import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizInfo;
import com.alipay.sofa.ark.spi.model.BizOperation;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.replay.Replay;
import com.alipay.sofa.ark.spi.replay.ReplayContext;
import com.alipay.sofa.ark.spi.service.biz.BizFactoryService;
import com.alipay.sofa.ark.spi.service.biz.BizFileGenerator;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.service.extension.ArkServiceLoader;
import com.alipay.sofa.ark.spi.service.injection.InjectionService;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

public class ArkClient {
    private static ArkLogger LOGGER = ArkLoggerFactory.getDefaultLogger();
    private static BizManagerService bizManagerService;
    private static BizFactoryService bizFactoryService;
    private static InjectionService injectionService;
    private static String[] arguments;
    private static final File bizInstallDirectory;

    private static File getBizInstallDirectory() {
        File workingDir = FileUtils.createTempDir((String)"sofa-ark");
        String configDir = ArkConfigs.getStringValue("com.alipay.sofa.ark.biz.dir");
        if (!StringUtils.isEmpty((String)configDir)) {
            if (!configDir.endsWith(File.separator)) {
                configDir = configDir + File.separator;
            }
            if (!(workingDir = new File(configDir)).exists()) {
                workingDir.mkdir();
            }
        }
        return workingDir;
    }

    public static File createBizSaveFile(String bizName, String bizVersion) {
        return new File(bizInstallDirectory, bizName + "-" + bizVersion + "-" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
    }

    public static InjectionService getInjectionService() {
        return injectionService;
    }

    public static void setInjectionService(InjectionService injectionService) {
        ArkClient.injectionService = injectionService;
    }

    public static BizManagerService getBizManagerService() {
        return bizManagerService;
    }

    public static void setBizManagerService(BizManagerService bizManagerService) {
        ArkClient.bizManagerService = bizManagerService;
    }

    public static BizFactoryService getBizFactoryService() {
        return bizFactoryService;
    }

    public static void setBizFactoryService(BizFactoryService bizFactoryService) {
        ArkClient.bizFactoryService = bizFactoryService;
    }

    public static String[] getArguments() {
        return arguments;
    }

    public static void setArguments(String[] arguments) {
        ArkClient.arguments = arguments;
    }

    public static ClientResponse installBiz(File bizFile) throws Throwable {
        return ArkClient.installBiz(bizFile, arguments);
    }

    public static ClientResponse installBiz(File bizFile, String[] args) throws Throwable {
        AssertUtils.assertNotNull((Object)bizFactoryService, (String)"bizFactoryService must not be null!");
        AssertUtils.assertNotNull((Object)bizManagerService, (String)"bizFactoryService must not be null!");
        AssertUtils.assertNotNull((Object)bizFile, (String)"bizFile must not be null!");
        Biz biz = bizFactoryService.createBiz(bizFile);
        ClientResponse response = new ClientResponse();
        if (bizManagerService.getBizByIdentity(biz.getIdentity()) != null || !bizManagerService.registerBiz(biz)) {
            return response.setCode(ResponseCode.REPEAT_BIZ).setMessage(String.format("Biz: %s has been installed or registered.", biz.getIdentity()));
        }
        try {
            biz.start(args);
            response.setCode(ResponseCode.SUCCESS).setMessage(String.format("Install Biz: %s success.", biz.getIdentity())).setBizInfos(Collections.singleton(biz));
            LOGGER.info(response.getMessage());
            return response;
        }
        catch (Throwable throwable) {
            response.setCode(ResponseCode.FAILED).setMessage(String.format("Install Biz: %s fail.", biz.getIdentity()));
            LOGGER.error(response.getMessage(), throwable);
            bizManagerService.unRegisterBizStrictly(biz.getBizName(), biz.getBizVersion());
            try {
                biz.stop();
            }
            catch (Throwable e) {
                LOGGER.error(String.format("UnInstall Biz: %s fail.", biz.getIdentity()), e);
                throw e;
            }
            return response;
        }
    }

    public static ClientResponse uninstallBiz(String bizName, String bizVersion) throws Throwable {
        AssertUtils.assertNotNull((Object)bizFactoryService, (String)"bizFactoryService must not be null!");
        AssertUtils.assertNotNull((Object)bizManagerService, (String)"bizFactoryService must not be null!");
        AssertUtils.assertNotNull((Object)bizName, (String)"bizName must not be null!");
        AssertUtils.assertNotNull((Object)bizVersion, (String)"bizVersion must not be null!");
        if (bizName.equals(ArkConfigs.getStringValue("com.alipay.sofa.ark.master.biz"))) {
            return new ClientResponse().setCode(ResponseCode.FAILED).setMessage("Master biz must not be uninstalled.");
        }
        Biz biz = bizManagerService.unRegisterBiz(bizName, bizVersion);
        ClientResponse response = new ClientResponse().setCode(ResponseCode.NOT_FOUND_BIZ).setMessage(String.format("Uninstall biz: %s not found.", BizIdentityUtils.generateBizIdentity((String)bizName, (String)bizVersion)));
        if (biz != null) {
            try {
                biz.stop();
            }
            catch (Throwable throwable) {
                LOGGER.error(String.format("UnInstall Biz: %s fail.", biz.getIdentity()), throwable);
                throw throwable;
            }
            response.setCode(ResponseCode.SUCCESS).setMessage(String.format("Uninstall biz: %s success.", biz.getIdentity()));
        }
        LOGGER.info(response.getMessage());
        return response;
    }

    public static ClientResponse checkBiz() {
        return ArkClient.checkBiz(null, null);
    }

    public static ClientResponse checkBiz(String bizName) {
        return ArkClient.checkBiz(bizName, null);
    }

    public static ClientResponse checkBiz(String bizName, String bizVersion) {
        AssertUtils.assertNotNull((Object)bizFactoryService, (String)"bizFactoryService must not be null!");
        AssertUtils.assertNotNull((Object)bizManagerService, (String)"bizFactoryService must not be null!");
        ClientResponse response = new ClientResponse();
        HashSet<BizInfo> bizInfoSet = new HashSet<BizInfo>();
        if (bizName != null && bizVersion != null) {
            Biz biz = bizManagerService.getBiz(bizName, bizVersion);
            if (biz != null) {
                bizInfoSet.add((BizInfo)biz);
            }
        } else if (bizName != null) {
            bizInfoSet.addAll(bizManagerService.getBiz(bizName));
        } else {
            bizInfoSet.addAll(bizManagerService.getBizInOrder());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Biz count=%d", bizInfoSet.size())).append("\n");
        for (BizInfo bizInfo : bizInfoSet) {
            sb.append(String.format("bizName=%s, bizVersion=%s, bizState=%s", bizInfo.getBizName(), bizInfo.getBizVersion(), bizInfo.getBizState())).append("\n");
        }
        response.setCode(ResponseCode.SUCCESS).setBizInfos(bizInfoSet).setMessage(sb.toString());
        LOGGER.info(String.format("Check Biz: %s", response.getMessage()));
        return response;
    }

    public static ClientResponse switchBiz(String bizName, String bizVersion) {
        AssertUtils.assertNotNull((Object)bizFactoryService, (String)"bizFactoryService must not be null!");
        AssertUtils.assertNotNull((Object)bizManagerService, (String)"bizFactoryService must not be null!");
        AssertUtils.assertNotNull((Object)bizName, (String)"bizName must not be null!");
        AssertUtils.assertNotNull((Object)bizVersion, (String)"bizVersion must not be null!");
        Biz biz = bizManagerService.getBiz(bizName, bizVersion);
        ClientResponse response = new ClientResponse().setCode(ResponseCode.NOT_FOUND_BIZ).setMessage(String.format("Switch biz: %s not found.", BizIdentityUtils.generateBizIdentity((String)bizName, (String)bizVersion)));
        if (biz != null) {
            if (biz.getBizState() != BizState.ACTIVATED && biz.getBizState() != BizState.DEACTIVATED) {
                response.setCode(ResponseCode.ILLEGAL_STATE_BIZ).setMessage(String.format("Switch Biz: %s's state must not be %s.", biz.getIdentity(), biz.getBizState()));
            } else {
                bizManagerService.activeBiz(bizName, bizVersion);
                response.setCode(ResponseCode.SUCCESS).setMessage(String.format("Switch biz: %s is activated.", biz.getIdentity()));
            }
        }
        LOGGER.info(response.getMessage());
        return response;
    }

    public static ClientResponse installOperation(BizOperation bizOperation) throws Throwable {
        return ArkClient.installOperation(bizOperation, arguments);
    }

    public static ClientResponse installOperation(BizOperation bizOperation, String[] args) throws Throwable {
        File bizFile;
        block2: {
            BizFileGenerator bizFileGenerator;
            AssertUtils.isTrue((boolean)BizOperation.OperationType.INSTALL.equals((Object)bizOperation.getOperationType()), (String)"Operation type must be install", (Object[])new Object[0]);
            bizFile = null;
            if (bizOperation.getParameters().get("bizUrl") != null) {
                URL url = new URL((String)bizOperation.getParameters().get("bizUrl"));
                bizFile = ArkClient.createBizSaveFile(bizOperation.getBizName(), bizOperation.getBizVersion());
                FileUtils.copyInputStreamToFile((InputStream)url.openStream(), (File)bizFile);
            }
            if (StringUtils.isEmpty((String)bizOperation.getBizName()) || StringUtils.isEmpty((String)bizOperation.getBizVersion())) break block2;
            Iterator iterator = ArkServiceLoader.loadExtension(BizFileGenerator.class).iterator();
            while (iterator.hasNext() && ((bizFile = (bizFileGenerator = (BizFileGenerator)iterator.next()).createBizFile(bizOperation.getBizName(), bizOperation.getBizVersion())) == null || !bizFile.exists())) {
            }
        }
        return ArkClient.installBiz(bizFile, args);
    }

    public static ClientResponse uninstallOperation(BizOperation bizOperation) throws Throwable {
        AssertUtils.isTrue((boolean)BizOperation.OperationType.UNINSTALL.equals((Object)bizOperation.getOperationType()), (String)"Operation type must be uninstall", (Object[])new Object[0]);
        return ArkClient.uninstallBiz(bizOperation.getBizName(), bizOperation.getBizVersion());
    }

    public static ClientResponse switchOperation(BizOperation bizOperation) {
        AssertUtils.isTrue((boolean)BizOperation.OperationType.SWITCH.equals((Object)bizOperation.getOperationType()), (String)"Operation type must be switch", (Object[])new Object[0]);
        return ArkClient.switchBiz(bizOperation.getBizName(), bizOperation.getBizVersion());
    }

    public static ClientResponse checkOperation(BizOperation bizOperation) {
        AssertUtils.isTrue((boolean)BizOperation.OperationType.SWITCH.equals((Object)bizOperation.getOperationType()), (String)"Operation type must be switch", (Object[])new Object[0]);
        return ArkClient.checkBiz(bizOperation.getBizName(), bizOperation.getBizVersion());
    }

    public static Object invocationReplay(String version, Replay replay) {
        try {
            ReplayContext.set((String)version);
            Object object = replay.invoke();
            return object;
        }
        finally {
            ReplayContext.unset();
        }
    }

    static {
        bizInstallDirectory = ArkClient.getBizInstallDirectory();
    }
}

