/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.api;

import com.alipay.sofa.ark.exception.ArkRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ArkConfigs {
    private static final ConcurrentMap<String, Object> CFG = new ConcurrentHashMap<String, Object>();

    public static void init(List<URL> confFiles) {
        try {
            for (URL url : confFiles) {
                ArkConfigs.loadConfigFile(url.openStream());
            }
        }
        catch (Exception e) {
            throw new ArkRuntimeException("Catch Exception when load ArkConfigs", (Throwable)e);
        }
    }

    private static void loadConfigFile(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        for (Object key : properties.keySet()) {
            CFG.put((String)key, properties.get(key));
        }
    }

    public static void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public static String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    public static String getStringValue(String primaryKey) {
        String val = ArkConfigs.getSystemProperty(primaryKey);
        if (val == null) {
            val = (String)CFG.get(primaryKey);
        }
        return val;
    }

    public static String getStringValue(String primaryKey, String defaultValue) {
        String val = ArkConfigs.getStringValue(primaryKey);
        return val == null ? defaultValue : val;
    }

    public static int getIntValue(String primaryKey, int defaultValue) {
        String val = ArkConfigs.getStringValue(primaryKey);
        return val == null ? defaultValue : Integer.valueOf(val);
    }

    public static Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>(CFG.keySet());
        keySet.addAll(new HashMap<Object, Object>(System.getProperties()).keySet());
        return keySet;
    }

    public static void putStringValue(String key, String value) {
        CFG.put(key, value);
    }

    public static boolean isEmbedEnable() {
        return Boolean.getBoolean("sofa.ark.embed.enable");
    }

    public static void setEmbedEnable(boolean enable) {
        System.setProperty("sofa.ark.embed.enable", enable ? "true" : "false");
    }

    public static boolean isEmbedStaticBizEnable() {
        return Boolean.getBoolean("sofa.ark.embed.static.biz.enable");
    }

    public static void setEmbedStaticBizEnable(boolean enable) {
        System.setProperty("sofa.ark.embed.static.biz.enable", enable ? "true" : "false");
    }
}

