/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.bootstrap;

import com.alipay.sofa.ark.bootstrap.AgentClassLoader;
import com.alipay.sofa.ark.bootstrap.ContainerClassLoader;
import com.alipay.sofa.ark.bootstrap.MainMethodRunner;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.loader.jar.JarFile;
import com.alipay.sofa.ark.spi.archive.ContainerArchive;
import com.alipay.sofa.ark.spi.archive.ExecutableArchive;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractLauncher {
    public Object launch(String[] args) throws Exception {
        if (!this.isEmbedEnable()) {
            JarFile.registerUrlProtocolHandler();
        }
        ClassLoader classLoader = this.createContainerClassLoader(this.getContainerArchive());
        ArrayList<String> attachArgs = new ArrayList<String>();
        attachArgs.add(String.format("%s%s=%s", "-A", "jar", this.getExecutableArchive().getUrl().toExternalForm()));
        attachArgs.addAll(Arrays.asList(args));
        return this.launch(attachArgs.toArray(new String[attachArgs.size()]), this.getMainClass(), classLoader);
    }

    public Object launch(String[] args, String classpath, Method method) throws Exception {
        if (!this.isEmbedEnable()) {
            JarFile.registerUrlProtocolHandler();
        }
        ClassLoader classLoader = this.createContainerClassLoader(this.getContainerArchive());
        ArrayList<String> attachArgs = new ArrayList<String>();
        attachArgs.add(String.format("%s%s=%s", "-A", "classpath", classpath));
        attachArgs.add(String.format("%s%s=%s", "-B", "className", method.getDeclaringClass().getName()));
        attachArgs.add(String.format("%s%s=%s", "-B", "methodName", method.getName()));
        attachArgs.addAll(Arrays.asList(args));
        return this.launch(attachArgs.toArray(new String[attachArgs.size()]), this.getMainClass(), classLoader);
    }

    public Object launch(String classpath, Class testClass) throws Exception {
        if (!this.isEmbedEnable()) {
            JarFile.registerUrlProtocolHandler();
        }
        ClassLoader classLoader = this.createContainerClassLoader(this.getContainerArchive());
        ArrayList<String> attachArgs = new ArrayList<String>();
        attachArgs.add(String.format("%s%s=%s", "-A", "classpath", classpath));
        attachArgs.add(String.format("%s%s=%s", "-B", "className", testClass.getCanonicalName()));
        return this.launch(attachArgs.toArray(new String[attachArgs.size()]), this.getMainClass(), classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object launch(String[] args, String mainClass, ClassLoader classLoader) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Object object = this.createMainMethodRunner(mainClass, args).run();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected MainMethodRunner createMainMethodRunner(String mainClass, String[] args) {
        return new MainMethodRunner(mainClass, args, null);
    }

    protected abstract ExecutableArchive getExecutableArchive() throws Exception;

    protected ContainerArchive getContainerArchive() throws Exception {
        return this.getExecutableArchive().getContainerArchive();
    }

    protected ClassLoader createContainerClassLoader(ContainerArchive containerArchive) throws Exception {
        List classpath = this.getExecutableArchive().getConfClasspath();
        classpath.addAll(Arrays.asList(containerArchive.getUrls()));
        URL[] agentUrls = ClassLoaderUtils.getAgentClassPath();
        AgentClassLoader agentClassLoader = agentUrls.length > 0 ? new AgentClassLoader(agentUrls, Thread.currentThread().getContextClassLoader()) : null;
        return this.createContainerClassLoader(classpath.toArray(new URL[0]), null, agentClassLoader);
    }

    protected ClassLoader createContainerClassLoader(URL[] urls, ClassLoader parent, ClassLoader agentClassLoader) {
        return this.isEmbedEnable() ? new ContainerClassLoader(urls, parent, this.getClass().getClassLoader(), agentClassLoader) : new ContainerClassLoader(urls, parent, agentClassLoader);
    }

    private boolean isEmbedEnable() {
        return Boolean.getBoolean("sofa.ark.embed.enable");
    }

    protected abstract String getMainClass() throws Exception;
}

