/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.loader.jar;

import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.loader.jar.JarEntry;
import com.alipay.sofa.ark.loader.jar.JarFile;
import com.alipay.sofa.ark.loader.util.ModifyPathUtils;
import com.alipay.sofa.ark.spi.archive.Archive;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public class JarUtils {
    private static final String CLASSPATH_ROOT_IDENTITY = "/target/classes";
    private static final String TEST_CLASSPATH_ROOT_IDENTITY = "/target/test-classes";
    private static final String TARGET_ROOT_IDENTITY = "/target/";
    private static final String JAR_POM_PROPERTIES_RELATIVE_PATH = "maven-archiver/pom.properties";
    private static final String JAR_ARTIFACT_ID = "artifactId";
    private static final String JAR_POM_PROPERTIES = "pom.properties";
    private static final String POM_FILE = "/pom.xml";
    private static final String VERSION_REGEX = "^([0-9]+\\.)+.+";
    private static final MavenXpp3Reader READER = new MavenXpp3Reader();
    public static final String JAR_SEPARATOR = "!/";
    private static final Map<String, Optional<String>> artifactIdCacheMap = new ConcurrentHashMap<String, Optional<String>>();

    static File searchPomProperties(File dirOrFile) {
        File[] files;
        if (dirOrFile == null || !dirOrFile.exists()) {
            return null;
        }
        if (dirOrFile.isFile() && JAR_POM_PROPERTIES.equals(dirOrFile.getName())) {
            return dirOrFile;
        }
        if (dirOrFile.isDirectory() && (files = dirOrFile.listFiles()) != null) {
            for (File file : files) {
                File result = JarUtils.searchPomProperties(file);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getArtifactIdFromLocalClassPath(String fileClassPath) {
        Throwable throwable;
        String pomPropertiesPath;
        String libraryFile = fileClassPath.replace("file:", "");
        int classesRootIndex = libraryFile.endsWith(CLASSPATH_ROOT_IDENTITY) ? libraryFile.indexOf(CLASSPATH_ROOT_IDENTITY) : libraryFile.indexOf("/target/classes/");
        int testClassesRootIndex = libraryFile.endsWith(TEST_CLASSPATH_ROOT_IDENTITY) ? libraryFile.indexOf(TEST_CLASSPATH_ROOT_IDENTITY) : libraryFile.indexOf("/target/test-classes/");
        String pomXmlPath = null;
        if (classesRootIndex != -1) {
            pomPropertiesPath = libraryFile.substring(0, classesRootIndex + TARGET_ROOT_IDENTITY.length()) + JAR_POM_PROPERTIES_RELATIVE_PATH;
            pomXmlPath = libraryFile.substring(0, classesRootIndex) + POM_FILE;
        } else if (testClassesRootIndex != -1) {
            pomPropertiesPath = libraryFile.substring(0, testClassesRootIndex + TARGET_ROOT_IDENTITY.length()) + JAR_POM_PROPERTIES_RELATIVE_PATH;
            pomXmlPath = libraryFile.substring(0, testClassesRootIndex) + POM_FILE;
        } else {
            File pomPropertiesFile = JarUtils.searchPomProperties(FileUtils.file((String)libraryFile));
            pomPropertiesPath = pomPropertiesFile != null && pomPropertiesFile.exists() ? pomPropertiesFile.getAbsolutePath() : null;
        }
        String artifactId = null;
        if (!StringUtils.isEmpty((String)pomPropertiesPath)) {
            try {
                throwable = null;
                try (InputStream inputStream = Files.newInputStream(FileUtils.file((String)pomPropertiesPath).toPath(), new OpenOption[0]);){
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    artifactId = properties.getProperty(JAR_ARTIFACT_ID);
                }
                catch (Throwable properties) {
                    throwable = properties;
                    throw properties;
                }
            }
            catch (IOException inputStream) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty(artifactId)) return artifactId;
        if (StringUtils.isEmpty(pomXmlPath)) return artifactId;
        try {
            throwable = null;
            try (FileReader fileReader = new FileReader(pomXmlPath);){
                Model model = READER.read((Reader)fileReader);
                String string = model.getArtifactId();
                return string;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return artifactId;
    }

    public static String parseArtifactId(String jarLocation) {
        String finalJarLocation = jarLocation = ModifyPathUtils.modifyPath(jarLocation);
        artifactIdCacheMap.computeIfAbsent(jarLocation, a -> {
            try {
                String artifactId;
                String[] as = a.split(JAR_SEPARATOR, -1);
                if (as.length == 1) {
                    String filePath = as[0];
                    if (a.endsWith(".jar")) {
                        artifactId = JarUtils.doGetArtifactIdFromFileName(filePath);
                        if (StringUtils.isEmpty((String)artifactId)) {
                            artifactId = JarUtils.parseArtifactIdFromJar(filePath);
                        }
                    } else {
                        artifactId = JarUtils.getArtifactIdFromLocalClassPath(filePath);
                    }
                } else if (as.length == 2) {
                    String filePath = as[0];
                    artifactId = JarUtils.doGetArtifactIdFromFileName(filePath);
                    if (StringUtils.isEmpty((String)artifactId)) {
                        artifactId = JarUtils.parseArtifactIdFromJar(filePath);
                    }
                } else if (as.length == 3) {
                    CharSequence[] jarPathInfo = Arrays.copyOf(as, as.length - 1);
                    String filePath = String.join((CharSequence)JAR_SEPARATOR, jarPathInfo);
                    artifactId = JarUtils.doGetArtifactIdFromFileName(filePath);
                    if (StringUtils.isEmpty((String)artifactId)) {
                        artifactId = JarUtils.parseArtifactIdFromJarInJar(filePath);
                    }
                } else {
                    CharSequence[] jarPathInfo = Arrays.copyOf(as, as.length - 1);
                    String filePath = String.join((CharSequence)JAR_SEPARATOR, jarPathInfo);
                    artifactId = JarUtils.doGetArtifactIdFromFileName(filePath);
                    if (StringUtils.isEmpty((String)artifactId)) {
                        artifactId = JarUtils.parseArtifactIdFromJarInJarInJarMore(filePath);
                    }
                }
                return Optional.ofNullable(artifactId);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to parse artifact id from jar %s.", finalJarLocation), e);
            }
        });
        return artifactIdCacheMap.get(jarLocation).orElse(null);
    }

    private static String doGetArtifactIdFromFileName(String jarLocation) {
        String[] jarInfos = jarLocation.split("/");
        if (jarInfos.length == 0) {
            return null;
        }
        String artifactVersion = jarInfos[jarInfos.length - 1];
        String[] artifactVersionInfos = artifactVersion.split("-");
        ArrayList<String> artifactInfos = new ArrayList<String>();
        boolean getVersion = false;
        for (String info : artifactVersionInfos) {
            if (!StringUtils.isEmpty((String)info) && info.matches(VERSION_REGEX)) {
                getVersion = true;
                break;
            }
            artifactInfos.add(info);
        }
        if (getVersion) {
            return String.join((CharSequence)"-", artifactInfos);
        }
        return null;
    }

    private static String parseArtifactIdFromJarInJar(String jarLocation) throws IOException {
        String rootPath = jarLocation.substring(0, jarLocation.lastIndexOf(JAR_SEPARATOR));
        String subNestedPath = jarLocation.substring(jarLocation.lastIndexOf(JAR_SEPARATOR) + 2);
        JarFile jarFile = new JarFile(FileUtils.file((String)rootPath));
        JarFileArchive jarFileArchive = new JarFileArchive(jarFile);
        List<Archive> archives = jarFileArchive.getNestedArchives(entry -> !StringUtils.isEmpty((String)entry.getName()) && entry.getName().equals(subNestedPath));
        if (archives.size() != 1) {
            return null;
        }
        Archive archive = archives.get(0);
        Properties properties = ((JarFileArchive)archive).getPomProperties();
        return properties.getProperty(JAR_ARTIFACT_ID);
    }

    private static String parseArtifactIdFromJarInJarInJarMore(String jarLocation) throws IOException {
        JarFile jarFile = JarUtils.getNestedRootJarFromJarLocation(jarLocation);
        JarFileArchive jarFileArchive = new JarFileArchive(jarFile);
        return jarFileArchive.getPomProperties().getProperty(JAR_ARTIFACT_ID);
    }

    public static JarFile getNestedRootJarFromJarLocation(String jarLocation) throws IOException {
        String jPath;
        String[] js = jarLocation.split(JAR_SEPARATOR, -1);
        JarFile rJarFile = new JarFile(FileUtils.file((String)js[0]));
        for (int i = 1; i < js.length && !StringUtils.isEmpty((String)(jPath = js[i])) && jPath.endsWith(".jar"); ++i) {
            try {
                JarEntry jarEntry = rJarFile.getJarEntry(jPath);
                rJarFile = rJarFile.getNestedJarFile((ZipEntry)jarEntry);
                continue;
            }
            catch (NullPointerException e) {
                throw new IOException(String.format("Failed to parse artifact id, jPath: %s", jPath));
            }
        }
        return rJarFile;
    }

    private static String parseArtifactIdFromJar(String jarLocation) throws IOException {
        jarLocation = FileUtils.decodePath((String)jarLocation);
        try (java.util.jar.JarFile jarFile = new java.util.jar.JarFile(jarLocation);){
            Enumeration<java.util.jar.JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                java.util.jar.JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(JAR_POM_PROPERTIES)) continue;
                try (InputStream is = jarFile.getInputStream(entry);){
                    Properties p = new Properties();
                    p.load(is);
                    String string = p.getProperty(JAR_ARTIFACT_ID);
                    return string;
                }
            }
            String string = null;
            return string;
        }
    }
}

