/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.loader;

import com.alipay.sofa.ark.bootstrap.ClasspathLauncher;
import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.loader.JarBizArchive;
import com.alipay.sofa.ark.loader.JarContainerArchive;
import com.alipay.sofa.ark.loader.JarPluginArchive;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import com.alipay.sofa.ark.spi.archive.ContainerArchive;
import com.alipay.sofa.ark.spi.archive.PluginArchive;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class EmbedClassPathArchive
extends ClasspathLauncher.ClassPathArchive {
    public EmbedClassPathArchive(String className, String method, URL[] urls) throws IOException {
        super(className, method, urls);
    }

    @Override
    public ContainerArchive getContainerArchive() throws Exception {
        List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/container/mark");
        if (urlList.isEmpty()) {
            return this.createDirectoryContainerArchive();
        }
        if (urlList.size() > 1) {
            throw new ArkRuntimeException("Duplicate Container Jar File Found.");
        }
        return new JarContainerArchive(this.getUrlJarFileArchive(urlList.get(0)));
    }

    @Override
    public List<BizArchive> getBizArchives() throws Exception {
        List<URL> urlList = this.filterBizUrl("com/alipay/sofa/ark/biz/mark");
        LinkedList<BizArchive> bizArchives = new LinkedList<BizArchive>();
        for (URL url : urlList) {
            if (url.getPath().contains(".jar!")) {
                Archive archiveFromJarEntry = this.getArchiveFromJarEntry(url);
                if (archiveFromJarEntry == null) continue;
                bizArchives.add(new JarBizArchive(archiveFromJarEntry));
                continue;
            }
            bizArchives.add(new JarBizArchive(new JarFileArchive(FileUtils.file((String)url.getFile()))));
        }
        return bizArchives;
    }

    private Archive getArchiveFromJarEntry(URL jarUrl) throws IOException {
        String jarPath = jarUrl.getPath().substring(0, jarUrl.getPath().indexOf("!"));
        String bizPath = jarUrl.getPath().substring(jarUrl.getPath().indexOf("!") + 2);
        List<Archive> nestedArchives = new JarFileArchive(FileUtils.file((String)jarPath)).getNestedArchives(entry -> entry.getName().equals(bizPath));
        if (nestedArchives.isEmpty()) {
            return null;
        }
        return nestedArchives.get(0);
    }

    public List<URL> filterBizUrl(String resource) throws Exception {
        ArrayList<URL> urlList = new ArrayList<URL>();
        Enumeration<URL> enumeration = this.urlClassLoader.findResources(resource);
        while (enumeration.hasMoreElements()) {
            URL resourceUrl = enumeration.nextElement();
            String resourceFile = resourceUrl.getFile();
            String jarFile = resourceFile.substring(0, resourceFile.length() - resource.length() - "!/".length());
            urlList.add(new URL(jarFile));
        }
        return urlList;
    }

    @Override
    public List<PluginArchive> getPluginArchives() throws Exception {
        List<URL> urlList = this.filterUrls("com/alipay/sofa/ark/plugin/mark");
        ArrayList<PluginArchive> pluginArchives = new ArrayList<PluginArchive>();
        for (URL url : urlList) {
            pluginArchives.add(new JarPluginArchive(this.getUrlJarFileArchive(url)));
        }
        return pluginArchives;
    }

    protected JarFileArchive getUrlJarFileArchive(URL url) throws IOException {
        String file = url.getFile();
        if (file.contains("!/")) {
            int pos = file.indexOf("!/");
            File fatJarFile = FileUtils.file((String)file.substring(0, pos));
            String nestedJar = file.substring(file.lastIndexOf("/") + 1);
            JarFileArchive fatJarFileArchive = new JarFileArchive(fatJarFile);
            List<Archive> matched = fatJarFileArchive.getNestedArchives(entry -> entry.getName().contains(nestedJar));
            return (JarFileArchive)matched.get(0);
        }
        return new JarFileArchive(FileUtils.file((String)file));
    }
}

