/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.loader.jar;

import com.alipay.sofa.ark.loader.data.RandomAccessData;
import com.alipay.sofa.ark.loader.data.RandomAccessDataFile;
import com.alipay.sofa.ark.loader.jar.AsciiBytes;
import com.alipay.sofa.ark.loader.jar.CentralDirectoryEndRecord;
import com.alipay.sofa.ark.loader.jar.CentralDirectoryFileHeader;
import com.alipay.sofa.ark.loader.jar.CentralDirectoryParser;
import com.alipay.sofa.ark.loader.jar.CentralDirectoryVisitor;
import com.alipay.sofa.ark.loader.jar.Handler;
import com.alipay.sofa.ark.loader.jar.JarEntry;
import com.alipay.sofa.ark.loader.jar.JarEntryFilter;
import com.alipay.sofa.ark.loader.jar.JarFileEntries;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarFile
extends java.util.jar.JarFile {
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final String POM_PROPERTIES = "pom.properties";
    private static final String PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    private static final String HANDLERS_PACKAGE = "com.alipay.sofa.ark.loader";
    private static final AsciiBytes META_INF = new AsciiBytes("META-INF/");
    private static final AsciiBytes SIGNATURE_FILE_EXTENSION = new AsciiBytes(".SF");
    private final RandomAccessDataFile rootFile;
    private final String pathFromRoot;
    private final RandomAccessData data;
    private final JarFileType type;
    private URL url;
    private JarFileEntries entries;
    private SoftReference<Manifest> manifest;
    private boolean signed;

    public JarFile(File file) throws IOException {
        this(new RandomAccessDataFile(file));
    }

    JarFile(RandomAccessDataFile file) throws IOException {
        this(file, "", file, JarFileType.DIRECT);
    }

    private JarFile(RandomAccessDataFile rootFile, String pathFromRoot, RandomAccessData data, JarFileType type) throws IOException {
        this(rootFile, pathFromRoot, data, null, type);
    }

    private JarFile(RandomAccessDataFile rootFile, String pathFromRoot, RandomAccessData data, JarEntryFilter filter, JarFileType type) throws IOException {
        super(rootFile.getFile());
        this.rootFile = rootFile;
        this.pathFromRoot = pathFromRoot;
        CentralDirectoryParser parser = new CentralDirectoryParser();
        this.entries = parser.addVisitor(new JarFileEntries(this, filter));
        parser.addVisitor(this.centralDirectoryVisitor());
        this.data = parser.parse(data, filter == null);
        this.type = type;
    }

    private CentralDirectoryVisitor centralDirectoryVisitor() {
        return new CentralDirectoryVisitor(){

            @Override
            public void visitStart(CentralDirectoryEndRecord endRecord, RandomAccessData centralDirectoryData) {
            }

            @Override
            public void visitFileHeader(CentralDirectoryFileHeader fileHeader, int dataOffset) {
                AsciiBytes name = fileHeader.getName();
                if (name.startsWith(META_INF) && name.endsWith(SIGNATURE_FILE_EXTENSION)) {
                    JarFile.this.signed = true;
                }
            }

            @Override
            public void visitEnd() {
            }
        };
    }

    protected final RandomAccessDataFile getRootJarFile() {
        return this.rootFile;
    }

    RandomAccessData getData() {
        return this.data;
    }

    @Override
    public Manifest getManifest() throws IOException {
        Manifest manifest;
        Manifest manifest2 = manifest = this.manifest == null ? null : this.manifest.get();
        if (manifest == null) {
            if (this.type == JarFileType.NESTED_DIRECTORY) {
                try (JarFile jarFile = new JarFile(this.getRootJarFile());){
                    manifest = jarFile.getManifest();
                }
            }
            try (InputStream inputStream = this.getInputStream(MANIFEST_NAME, RandomAccessData.ResourceAccess.ONCE);){
                if (inputStream == null) {
                    Manifest manifest3 = null;
                    return manifest3;
                }
                manifest = new Manifest(inputStream);
            }
            this.manifest = new SoftReference<Manifest>(manifest);
        }
        return manifest;
    }

    public Properties getPomProperties() throws IOException {
        Enumeration<java.util.jar.JarEntry> entries = this.entries();
        Properties p = new Properties();
        while (entries.hasMoreElements()) {
            java.util.jar.JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().endsWith(POM_PROPERTIES)) continue;
            try (InputStream is = this.getInputStream(jarEntry);){
                p.load(is);
                Properties properties = p;
                return properties;
            }
        }
        return p;
    }

    @Override
    public Enumeration<java.util.jar.JarEntry> entries() {
        final Iterator<JarEntry> iterator = this.entries.iterator();
        return new Enumeration<java.util.jar.JarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public java.util.jar.JarEntry nextElement() {
                return (java.util.jar.JarEntry)iterator.next();
            }
        };
    }

    @Override
    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    public boolean containsEntry(String name) {
        return this.entries.containsEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        return this.entries.getEntry(name);
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry ze) throws IOException {
        return this.getInputStream(ze, RandomAccessData.ResourceAccess.PER_READ);
    }

    public InputStream getInputStream(ZipEntry ze, RandomAccessData.ResourceAccess access) throws IOException {
        if (ze instanceof JarEntry) {
            return this.entries.getInputStream((JarEntry)ze, access);
        }
        return this.getInputStream(ze == null ? null : ze.getName(), access);
    }

    InputStream getInputStream(String name, RandomAccessData.ResourceAccess access) throws IOException {
        return this.entries.getInputStream(name, access);
    }

    public synchronized JarFile getNestedJarFile(ZipEntry entry) throws IOException {
        return this.getNestedJarFile((JarEntry)entry);
    }

    public synchronized JarFile getNestedJarFile(JarEntry entry) throws IOException {
        try {
            return this.createJarFileFromEntry(entry);
        }
        catch (Exception ex) {
            throw new IOException("Unable to open nested jar file '" + entry.getName() + "'", ex);
        }
    }

    private JarFile createJarFileFromEntry(JarEntry entry) throws IOException {
        if (entry.isDirectory()) {
            return this.createJarFileFromDirectoryEntry(entry);
        }
        return this.createJarFileFromFileEntry(entry);
    }

    private JarFile createJarFileFromDirectoryEntry(JarEntry entry) throws IOException {
        final AsciiBytes sourceName = new AsciiBytes(entry.getName());
        JarEntryFilter filter = new JarEntryFilter(){

            @Override
            public AsciiBytes apply(AsciiBytes name) {
                if (name.startsWith(sourceName) && !name.equals(sourceName)) {
                    return name.substring(sourceName.length());
                }
                return null;
            }
        };
        return new JarFile(this.rootFile, this.pathFromRoot + "!/" + entry.getName().substring(0, sourceName.length() - 1), this.data, filter, JarFileType.NESTED_DIRECTORY);
    }

    private JarFile createJarFileFromFileEntry(JarEntry entry) throws IOException {
        if (entry.getMethod() != 0) {
            throw new IllegalStateException("Unable to open nested entry '" + entry.getName() + "'. It has been compressed and nested jar files must be stored without compression. Please check the mechanism used to create your executable jar file");
        }
        RandomAccessData entryData = this.entries.getEntryData(entry.getName());
        return new JarFile(this.rootFile, this.pathFromRoot + "!/" + entry.getName(), entryData, JarFileType.NESTED_JAR);
    }

    @Override
    public int size() {
        return (int)this.data.getSize();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.rootFile.close();
    }

    public URL getUrl() throws MalformedURLException {
        if (this.url == null) {
            Handler handler = new Handler(this);
            Object file = this.rootFile.getFile().toURI() + this.pathFromRoot + "!/";
            file = ((String)file).replace("file:////", "file://");
            this.url = new URL("jar", "", -1, (String)file, handler);
        }
        return this.url;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        String str = this.rootFile.getFile().toString();
        StringBuilder sb = new StringBuilder(str.length() + this.pathFromRoot.length());
        return sb.append(str).append(this.pathFromRoot).toString();
    }

    boolean isSigned() {
        return this.signed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupEntryCertificates(JarEntry entry) {
        try (JarInputStream inputStream = new JarInputStream(this.getData().getInputStream(RandomAccessData.ResourceAccess.ONCE));){
            java.util.jar.JarEntry certEntry = inputStream.getNextJarEntry();
            while (certEntry != null) {
                inputStream.closeEntry();
                if (entry.getName().equals(certEntry.getName())) {
                    this.setCertificates(entry, certEntry);
                }
                this.setCertificates(this.getJarEntry(certEntry.getName()), certEntry);
                certEntry = inputStream.getNextJarEntry();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void setCertificates(JarEntry entry, java.util.jar.JarEntry certEntry) {
        if (entry != null) {
            entry.setCertificates(certEntry);
        }
    }

    public void clearCache() {
        this.entries.clearCache();
    }

    protected String getPathFromRoot() {
        return this.pathFromRoot;
    }

    JarFileType getType() {
        return this.type;
    }

    public static void registerUrlProtocolHandler() {
        String handlers = System.getProperty(PROTOCOL_HANDLER, "");
        System.setProperty(PROTOCOL_HANDLER, (String)("".equals(handlers) ? HANDLERS_PACKAGE : handlers + "|com.alipay.sofa.ark.loader"));
        JarFile.resetCachedUrlHandlers();
    }

    private static void resetCachedUrlHandlers() {
        try {
            URL.setURLStreamHandlerFactory(null);
        }
        catch (Error error) {
            // empty catch block
        }
    }

    static enum JarFileType {
        DIRECT,
        NESTED_DIRECTORY,
        NESTED_JAR;

    }
}

