/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.condition;

import com.alipay.sofa.ark.springboot.condition.ConditionalOnSpringBootVersion;
import java.util.Map;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Order(value=-2147483548)
public class OnSpringBootVersion
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map springBootVersion = metadata.getAnnotationAttributes(ConditionalOnSpringBootVersion.class.getCanonicalName());
        if (springBootVersion == null || springBootVersion.get("version") == null) {
            return new ConditionOutcome(false, "No specified spring boot version.");
        }
        ConditionalOnSpringBootVersion.Version version = (ConditionalOnSpringBootVersion.Version)((Object)springBootVersion.get("version"));
        if (ConditionalOnSpringBootVersion.Version.ANY.equals((Object)version)) {
            return new ConditionOutcome(true, "Conditional on Any Spring Boot.");
        }
        if (ConditionalOnSpringBootVersion.Version.OneX.equals((Object)version)) {
            if (SpringBootVersion.getVersion().startsWith("1")) {
                return new ConditionOutcome(true, "Conditional on OneX Spring Boot.");
            }
            return new ConditionOutcome(false, "Conditional on OneX Spring Boot.");
        }
        if (ConditionalOnSpringBootVersion.Version.TwoX.equals((Object)version)) {
            if (SpringBootVersion.getVersion().startsWith("2")) {
                return new ConditionOutcome(true, "Conditional on TwoX Spring Boot.");
            }
            return new ConditionOutcome(false, "Conditional on TwoX Spring Boot.");
        }
        throw new IllegalStateException("Error Spring Boot Version.");
    }
}

