/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.adapter;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.core.ContextBase;
import com.alipay.sofa.ark.common.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ArkLogbackContextSelector
implements ContextSelector {
    private static final Map<ClassLoader, LoggerContext> CLASS_LOADER_LOGGER_CONTEXT = new HashMap<ClassLoader, LoggerContext>();
    private static final String BIZ_CLASS_LOADER = "com.alipay.sofa.ark.container.service.classloader.BizClassLoader";
    private static final String CONTAINER_CLASS_LOADER = "com.alipay.sofa.ark.bootstrap.ContainerClassLoader";
    private LoggerContext defaultLoggerContext;

    public ArkLogbackContextSelector(LoggerContext loggerContext) {
        this.defaultLoggerContext = loggerContext;
    }

    public LoggerContext getLoggerContext() {
        ClassLoader classLoader = this.findClassLoader();
        if (classLoader == null) {
            return this.defaultLoggerContext;
        }
        return this.getContext(classLoader);
    }

    private ClassLoader findClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && CONTAINER_CLASS_LOADER.equals(classLoader.getClass().getName())) {
            return null;
        }
        if (classLoader != null && BIZ_CLASS_LOADER.equals(classLoader.getClass().getName())) {
            return classLoader;
        }
        Class<?>[] context = new SecurityManager(){

            @Override
            public Class<?>[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (context == null || context.length == 0) {
            return null;
        }
        for (Class<?> cls : context) {
            if (cls.getClassLoader() == null || !BIZ_CLASS_LOADER.equals(cls.getClassLoader().getClass().getName())) continue;
            return cls.getClassLoader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LoggerContext getContext(ClassLoader cls) {
        LoggerContext loggerContext = CLASS_LOADER_LOGGER_CONTEXT.get(cls);
        if (null != loggerContext) return loggerContext;
        Class<ArkLogbackContextSelector> clazz = ArkLogbackContextSelector.class;
        synchronized (ArkLogbackContextSelector.class) {
            loggerContext = CLASS_LOADER_LOGGER_CONTEXT.get(cls);
            if (null != loggerContext) return loggerContext;
            loggerContext = new LoggerContext();
            loggerContext.setName(Integer.toHexString(System.identityHashCode(cls)));
            CLASS_LOADER_LOGGER_CONTEXT.put(cls, loggerContext);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return loggerContext;
        }
    }

    public LoggerContext getLoggerContext(String name) {
        if (StringUtils.isEmpty(name)) {
            return this.defaultLoggerContext;
        }
        for (ClassLoader classLoader : CLASS_LOADER_LOGGER_CONTEXT.keySet()) {
            LoggerContext loggerContext = CLASS_LOADER_LOGGER_CONTEXT.get(classLoader);
            if (!name.equals(loggerContext.getName())) continue;
            return loggerContext;
        }
        return this.defaultLoggerContext;
    }

    public LoggerContext getDefaultLoggerContext() {
        return this.defaultLoggerContext;
    }

    public LoggerContext detachLoggerContext(String loggerContextName) {
        if (StringUtils.isEmpty(loggerContextName)) {
            return null;
        }
        for (ClassLoader classLoader : CLASS_LOADER_LOGGER_CONTEXT.keySet()) {
            LoggerContext loggerContext = CLASS_LOADER_LOGGER_CONTEXT.get(classLoader);
            if (!loggerContextName.equals(loggerContext.getName())) continue;
            return this.removeContext(classLoader);
        }
        return null;
    }

    public LoggerContext removeContext(ClassLoader cls) {
        if (cls == null) {
            return null;
        }
        return CLASS_LOADER_LOGGER_CONTEXT.remove(cls);
    }

    public List<String> getContextNames() {
        return CLASS_LOADER_LOGGER_CONTEXT.values().stream().map(ContextBase::getName).collect(Collectors.toList());
    }
}

