/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ReflectionUtils {
    public static void doWithFields(Class<?> clazz, FieldCallback fc) {
        AssertUtils.assertNotNull(clazz, "Class should not be null");
        Class<?> searchType = clazz;
        do {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                fc.doWith(field);
            }
        } while ((searchType = searchType.getSuperclass()) != null && searchType != Object.class);
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws ArkRuntimeException;
    }
}

