/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import com.alipay.sofa.ark.common.util.AssertUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final int CHAR_A = 65;
    public static final int CHAR_Z = 90;
    public static final int CASE_GAP = 32;
    public static final String CR = "\r";

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isSameStr(String a, String b) {
        if (a == null && b != null) {
            return false;
        }
        if (a == null && b == null) {
            return true;
        }
        return a.equals(b);
    }

    public static String setToStr(Set<String> stringSet, String delimiter) {
        return StringUtils.setToStr(stringSet, delimiter, EMPTY_STRING);
    }

    public static String setToStr(Set<String> stringSet, String delimiter, String defaultRet) {
        if (stringSet == null || stringSet.isEmpty()) {
            return defaultRet;
        }
        AssertUtils.assertNotNull(delimiter, "Delimiter should not be null.");
        StringBuilder sb = new StringBuilder();
        for (String str : stringSet) {
            sb.append(str.trim()).append(delimiter);
        }
        return sb.toString().substring(0, sb.length() - delimiter.length());
    }

    public static Set<String> strToSet(String str, String delimiter) {
        return new LinkedHashSet<String>(StringUtils.strToList(str, delimiter));
    }

    public static List<String> strToList(String str, String delimiter) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (String s : str.split(delimiter)) {
            stringList.add(s.trim());
        }
        return stringList;
    }

    public static boolean startWithToLowerCase(String thisString, String anotherString) {
        boolean ret;
        AssertUtils.assertNotNull(thisString, "Param must not be null!");
        AssertUtils.assertNotNull(anotherString, "Param must not be null!");
        if (thisString.length() < anotherString.length()) {
            return false;
        }
        int index = 0;
        do {
            if (thisString.charAt(index) > 'Z' || thisString.charAt(index) < 'A') {
                ret = thisString.charAt(index) == anotherString.charAt(index);
                continue;
            }
            boolean bl = ret = thisString.charAt(index) + 32 == anotherString.charAt(index);
        } while (ret && ++index < anotherString.length());
        return ret;
    }

    public static String removeCR(String originalStr) {
        return StringUtils.removeSpcChar(originalStr, CR);
    }

    public static String removeSpcChar(String originalStr, String spcChar) {
        AssertUtils.assertNotNull(spcChar, "SpcChar must not be null!");
        if (originalStr == null || originalStr.isEmpty()) {
            return originalStr;
        }
        return originalStr.replaceAll(String.format("[%s]", spcChar), EMPTY_STRING);
    }
}

