/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha1Hash(File file) throws IOException {
        String string;
        DigestInputStream inputStream = new DigestInputStream(new FileInputStream(file), MessageDigest.getInstance("SHA-1"));
        try {
            byte[] buffer = new byte[4098];
            while (inputStream.read(buffer) != -1) {
            }
            string = FileUtils.bytesToHex(inputStream.getMessageDigest().digest());
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException(ex);
            }
        }
        inputStream.close();
        return string;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        for (byte b : bytes) {
            hex.append(String.format("%02x", b));
        }
        return hex.toString();
    }

    public static synchronized File createTempDir(String subPath) {
        File baseDir = FileUtils.file(System.getProperty("java.io.tmpdir"));
        File tempDir = new File(baseDir, subPath);
        if (tempDir.exists()) {
            return tempDir;
        }
        if (tempDir.mkdir()) {
            return tempDir;
        }
        throw new ArkRuntimeException("Failed to create temp file");
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)source, (File)destination);
    }

    public static String getCompatiblePath(String path) {
        if (System.getProperty("os.name").toLowerCase().indexOf("window") > -1) {
            return path.replace("\\", "/");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(File root, String targetPath) throws IOException {
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(root);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirPath = targetPath + File.separator + entry.getName();
                    File dir = FileUtils.file(dirPath);
                    dir.mkdirs();
                    continue;
                }
                InputStream inputStream = null;
                OutputStream fileOutputStream = null;
                try {
                    int count;
                    File fileParent;
                    inputStream = zipFile.getInputStream(entry);
                    File file = FileUtils.file(targetPath + File.separator + entry.getName());
                    if (!file.exists() && !(fileParent = file.getParentFile()).exists()) {
                        fileParent.mkdirs();
                    }
                    file.createNewFile();
                    fileOutputStream = new FileOutputStream(file);
                    byte[] buf = new byte[8192];
                    while ((count = inputStream.read(buf)) != -1) {
                        ((FileOutputStream)fileOutputStream).write(buf, 0, count);
                    }
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.flush();
                        ((FileOutputStream)fileOutputStream).close();
                    }
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            File file = FileUtils.file(targetPath);
            return file;
        }
    }

    public static File mkdir(String dirPath) {
        if (StringUtils.isEmpty(dirPath)) {
            return null;
        }
        File dir = FileUtils.file(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static String decodePath(String path) {
        try {
            return URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return path;
        }
    }

    public static File file(String path) {
        return new File(FileUtils.decodePath(path));
    }

    public static File file(String parent, String path) {
        return new File(FileUtils.decodePath(parent), path);
    }
}

