/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import java.io.IOException;
import java.net.ServerSocket;

public class PortSelectUtils {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 65535;

    public static synchronized int selectAvailablePort(int defaultPort, int maxLength) {
        for (int i = defaultPort; i < defaultPort + maxLength; ++i) {
            try {
                if (!PortSelectUtils.available(i)) continue;
                return i;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static boolean available(int port) {
        boolean bl;
        if (port < 1100 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        ServerSocket ss = new ServerSocket(port);
        try {
            ss.setReuseAddress(true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ss.close();
        return bl;
    }
}

