/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot2.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchClassLoaderFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(SwitchClassLoaderFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader bizClassLoader;
            if ("com.alipay.sofa.ark.web.embed.tomcat.ArkTomcatEmbeddedWebappClassLoader".equals(oldClassloader.getClass().getName()) && (bizClassLoader = oldClassloader.getParent()) != null) {
                this.logger.debug("switch web classLoader from {} to {}", (Object)oldClassloader, (Object)bizClassLoader);
                Thread.currentThread().setContextClassLoader(bizClassLoader);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    public void destroy() {
        super.destroy();
    }
}

