/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.boot.mojo;

import com.alipay.sofa.ark.tools.Libraries;
import com.alipay.sofa.ark.tools.Library;
import com.alipay.sofa.ark.tools.LibraryCallback;
import com.alipay.sofa.ark.tools.LibraryScope;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;

public class ArtifactsLibraries
implements Libraries {
    private static final Map<String, LibraryScope> SCOPES;
    private final Set<Artifact> artifacts;
    private final Collection<Dependency> unpacks;
    private final Log log;

    public ArtifactsLibraries(Set<Artifact> artifacts, Collection<Dependency> unpacks, Log log) {
        this.artifacts = artifacts;
        this.unpacks = unpacks;
        this.log = log;
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        Set<String> duplicates = this.getDuplicates(this.artifacts);
        for (Artifact artifact : this.artifacts) {
            LibraryScope scope = SCOPES.get(artifact.getScope());
            if (scope == null || artifact.getFile() == null) continue;
            String name = this.getFileName(artifact);
            if (duplicates.contains(name)) {
                this.log.debug((CharSequence)String.format("Duplicate found: %s", name));
                name = artifact.getGroupId() + "-" + name;
                this.log.debug((CharSequence)String.format("Renamed to: %s", name));
            }
            Library library = new Library(name, artifact.getFile(), scope, this.isUnpackRequired(artifact));
            library.setArtifactId(artifact.getArtifactId());
            callback.library(library);
        }
    }

    private Set<String> getDuplicates(Set<Artifact> artifacts) {
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        for (Artifact artifact : artifacts) {
            String fileName = this.getFileName(artifact);
            if (artifact.getFile() == null || seen.add(fileName)) continue;
            duplicates.add(fileName);
        }
        return duplicates;
    }

    private boolean isUnpackRequired(Artifact artifact) {
        if (this.unpacks != null) {
            for (Dependency unpack : this.unpacks) {
                if (!artifact.getGroupId().equals(unpack.getGroupId()) || !artifact.getArtifactId().equals(unpack.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    private String getFileName(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getArtifactId()).append("-").append(artifact.getBaseVersion());
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            sb.append("-").append(classifier);
        }
        sb.append(".").append(artifact.getArtifactHandler().getExtension());
        return sb.toString();
    }

    static {
        HashMap<String, LibraryScope> libraryScopes = new HashMap<String, LibraryScope>();
        libraryScopes.put("compile", LibraryScope.COMPILE);
        libraryScopes.put("runtime", LibraryScope.RUNTIME);
        libraryScopes.put("provided", LibraryScope.PROVIDED);
        libraryScopes.put("system", LibraryScope.COMPILE);
        SCOPES = Collections.unmodifiableMap(libraryScopes);
    }
}

