/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.boot.mojo;

import com.alipay.sofa.ark.tools.ArtifactItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class MavenUtils {
    private static List<String> UN_LOG_SCOPES = Arrays.asList("provided", "test", "import", "system");

    public static boolean isRootProject(MavenProject project) {
        if (project == null) {
            return true;
        }
        return !project.hasParent() || project.getParent().getBasedir() == null;
    }

    public static MavenProject getRootProject(MavenProject project) {
        if (project == null) {
            return null;
        }
        MavenProject parent = project;
        while (parent.hasParent() && parent.getParent().getBasedir() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static Set<ArtifactItem> convert(String depTreeContent) {
        String[] contents;
        HashSet<ArtifactItem> artifactItems = new HashSet<ArtifactItem>();
        for (String content : contents = depTreeContent.split("\n")) {
            ArtifactItem artifactItem = MavenUtils.getArtifactItem(content);
            if (artifactItem == null || "test".equals(artifactItem.getScope())) continue;
            artifactItems.add(artifactItem);
        }
        return artifactItems;
    }

    private static ArtifactItem getArtifactItem(String lineContent) {
        if (com.alipay.sofa.ark.common.util.StringUtils.isEmpty((String)lineContent)) {
            return null;
        }
        String[] contentInfos = (lineContent = com.alipay.sofa.ark.common.util.StringUtils.removeCR((String)lineContent)).split(" ");
        if (contentInfos.length == 0) {
            return null;
        }
        Optional<String> artifactStrOp = Arrays.stream(contentInfos).filter(c -> c.contains(":")).findFirst();
        if (!artifactStrOp.isPresent()) {
            return null;
        }
        String[] artifactInfos = artifactStrOp.get().split(":");
        ArtifactItem artifactItem = new ArtifactItem();
        if (artifactInfos.length == 5) {
            artifactItem.setGroupId(artifactInfos[0]);
            artifactItem.setArtifactId(artifactInfos[1]);
            artifactItem.setType(artifactInfos[2]);
            artifactItem.setVersion(artifactInfos[3]);
            artifactItem.setScope(artifactInfos[4]);
        } else if (artifactInfos.length == 6) {
            artifactItem.setGroupId(artifactInfos[0]);
            artifactItem.setArtifactId(artifactInfos[1]);
            artifactItem.setType(artifactInfos[2]);
            artifactItem.setClassifier(artifactInfos[3]);
            artifactItem.setVersion(artifactInfos[4]);
            artifactItem.setScope(artifactInfos[5]);
        } else {
            return null;
        }
        return artifactItem;
    }

    public static boolean inUnLogScopes(String scope) {
        return UN_LOG_SCOPES.contains(scope);
    }

    public static String getGAVIdentity(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
    }

    public static String getArtifactIdentity(Artifact artifact) {
        if (artifact.hasClassifier()) {
            return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion() + ":" + artifact.getClassifier() + ":" + artifact.getType();
        }
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion() + ":" + artifact.getType();
    }

    public static String getArtifactIdentityWithoutVersion(Artifact artifact) {
        if (artifact.hasClassifier()) {
            return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getClassifier() + ":" + artifact.getType();
        }
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType();
    }

    public static String getDependencyIdentity(Dependency dependency) {
        if (StringUtils.isNotEmpty((CharSequence)dependency.getClassifier())) {
            return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getClassifier() + ":" + dependency.getType();
        }
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getType();
    }

    public static String getDependencyIdentityWithoutVersion(Dependency dependency) {
        if (StringUtils.isNotEmpty((CharSequence)dependency.getClassifier())) {
            return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getClassifier() + ":" + dependency.getType();
        }
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getType();
    }
}

