/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.boot.mojo;

import com.alipay.sofa.ark.boot.mojo.ArtifactsLibraries;
import com.alipay.sofa.ark.boot.mojo.MavenUtils;
import com.alipay.sofa.ark.boot.mojo.ModuleSlimConfig;
import com.alipay.sofa.ark.boot.mojo.ModuleSlimStrategy;
import com.alipay.sofa.ark.boot.mojo.model.ArkConfigHolder;
import com.alipay.sofa.ark.boot.mojo.utils.ParseUtils;
import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.tools.ArtifactItem;
import com.alipay.sofa.ark.tools.Libraries;
import com.alipay.sofa.ark.tools.Repackager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.tree.TreeMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends TreeMojo {
    private static final String BIZ_NAME = "com.alipay.sofa.ark.bizName";
    private static final String DEFAULT_EXCLUDE_RULES = "rules.txt";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private MavenSession mavenSession;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.basedir}", required=true)
    private File baseDir;
    @Deprecated
    @Parameter(defaultValue="", required=false)
    private String packExcludesConfig;
    @Parameter(defaultValue="", required=false)
    private String packExcludesUrl;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(property="sofa.ark.repackage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="ark-biz", readonly=true)
    private String bizClassifier;
    @Parameter(defaultValue="${project.artifactId}")
    private String bizName;
    @Parameter(defaultValue="${project.version}")
    private String bizVersion;
    @Parameter(defaultValue="100", property="sofa.ark.biz.priority")
    protected Integer priority;
    @Parameter(defaultValue="ark-executable", readonly=true)
    private String arkClassifier;
    @Parameter(defaultValue="false")
    private boolean attach;
    @Parameter
    private String mainClass;
    @Parameter
    private List<Dependency> requiresUnpack;
    private String arkVersion;
    private ProjectBuildingRequest projectBuildingRequest;
    @Parameter(defaultValue="")
    private LinkedHashSet<String> excludes = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> excludeGroupIds = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> excludeArtifactIds = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> includes = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> includeGroupIds = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> includeArtifactIds = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> denyImportPackages;
    @Parameter(defaultValue="")
    private LinkedHashSet<String> denyImportClasses;
    @Parameter(defaultValue="")
    private LinkedHashSet<String> denyImportResources;
    @Parameter(defaultValue="")
    private LinkedHashSet<String> injectPluginDependencies = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> injectPluginExportPackages = new LinkedHashSet();
    @Parameter(defaultValue="false")
    private boolean packageProvided;
    @Parameter(defaultValue="false")
    private boolean skipArkExecutable;
    @Parameter(defaultValue="true")
    private boolean keepArkBizJar;
    @Parameter(defaultValue="/", required=true)
    private String webContextPath;
    @Parameter(defaultValue="false")
    private boolean declaredMode;
    @Parameter(defaultValue="false")
    private boolean disableGitInfo;
    @Parameter(defaultValue="")
    private File gitDirectory;
    @Parameter(defaultValue="")
    private String baseDependencyParentIdentity;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("war".equals(this.mavenProject.getPackaging())) {
            this.getLog().debug((CharSequence)"repackage goal could not be applied to war project.");
            return;
        }
        if ("pom".equals(this.mavenProject.getPackaging())) {
            this.getLog().debug((CharSequence)"repackage goal could not be applied to pom project.");
            return;
        }
        if (StringUtils.equals((CharSequence)this.arkClassifier, (CharSequence)this.bizClassifier)) {
            this.getLog().debug((CharSequence)"Executable fat jar should be different from 'plug-in' module jar.");
            return;
        }
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping repackaging as configuration.");
            return;
        }
        this.projectBuildingRequest = this.mavenProject.getProjectBuildingRequest();
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        this.arkVersion = pluginDescriptor.getVersion();
        this.repackage();
    }

    private void repackage() throws MojoExecutionException, MojoFailureException {
        File source = this.mavenProject.getArtifact().getFile();
        File appTarget = this.getAppTargetFile();
        File moduleTarget = this.getModuleTargetFile();
        Repackager repackager = this.getRepackager(source);
        ArtifactsLibraries libraries = new ArtifactsLibraries(this.getAdditionalArtifact(), this.requiresUnpack, this.getLog());
        try {
            if (repackager.isDeclaredMode()) {
                Set<ArtifactItem> artifactItems = MavenUtils.isRootProject(this.mavenProject) ? this.getAllArtifact() : this.getAllArtifactByMavenTree();
                artifactItems.addAll(this.getDeclaredLibrariesWhitelist());
                repackager.prepareDeclaredLibraries(artifactItems);
            }
            MavenProject rootProject = MavenUtils.getRootProject(this.mavenProject);
            repackager.setGitDirectory(this.getGitDirectory(rootProject));
            repackager.repackage(appTarget, moduleTarget, (Libraries)libraries);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        this.updateArtifact(appTarget, repackager.getModuleTargetFile());
    }

    protected Set<ArtifactItem> getDeclaredLibrariesWhitelist() throws IOException {
        HashSet<ArtifactItem> res = new HashSet<ArtifactItem>();
        Properties prop = ArkConfigHolder.getArkProperties(this.baseDir.getAbsolutePath());
        Map<String, Object> arkYaml = ArkConfigHolder.getArkYaml(this.baseDir.getAbsolutePath());
        HashSet<String> declaredLibrariesWhitelist = new HashSet<String>();
        declaredLibrariesWhitelist.addAll(ParseUtils.getStringSet(prop, "declared.libraries.whitelist"));
        declaredLibrariesWhitelist.addAll(ParseUtils.getStringSet(arkYaml, "declared.libraries.whitelist"));
        for (String declaredLibrary : declaredLibrariesWhitelist) {
            res.add(ArtifactItem.parseArtifactItem((String)declaredLibrary));
        }
        return res;
    }

    private File getGitDirectory(MavenProject rootProject) {
        if (this.disableGitInfo) {
            return null;
        }
        if (this.gitDirectory != null && this.gitDirectory.exists()) {
            return this.gitDirectory;
        }
        return FileUtils.file((String)(rootProject.getBasedir().getAbsolutePath() + "/.git"));
    }

    private void parseArtifactItems(DependencyNode rootNode, Set<ArtifactItem> result) {
        if (rootNode != null) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)rootNode.getArtifact().getScope(), (CharSequence)"test")) {
                result.add(ArtifactItem.parseArtifactItem((Artifact)rootNode.getArtifact()));
            }
            if (CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
                for (DependencyNode node : rootNode.getChildren()) {
                    this.parseArtifactItems(node, result);
                }
            }
        }
    }

    private DependencyNode parseDependencyGraph() throws MojoExecutionException, MojoFailureException {
        if (null == super.getDependencyGraph()) {
            super.execute();
        }
        return super.getDependencyGraph();
    }

    private Set<ArtifactItem> getAllArtifact() throws MojoExecutionException, MojoFailureException {
        DependencyNode dependencyNode = this.parseDependencyGraph();
        HashSet<ArtifactItem> results = new HashSet<ArtifactItem>();
        this.parseArtifactItems(dependencyNode, results);
        return results;
    }

    private Set<ArtifactItem> getAllArtifactByMavenTree() throws MojoExecutionException, MojoFailureException {
        MavenProject rootProject = MavenUtils.getRootProject(this.mavenProject);
        this.getLog().info((CharSequence)("root project path: " + rootProject.getBasedir().getAbsolutePath()));
        try {
            if (this.mavenProject.getBasedir() != null) {
                this.doGetAllArtifactByMavenTree(this.mavenProject);
                return this.getAllArtifact();
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().warn((CharSequence)"execute dependency:tree failed, try to execute dependency:tree in root project");
        }
        return this.doGetAllArtifactByMavenTree(MavenUtils.getRootProject(this.mavenProject));
    }

    private Set<ArtifactItem> doGetAllArtifactByMavenTree(MavenProject project) throws MojoExecutionException {
        File baseDir = project.getBasedir();
        this.getLog().info((CharSequence)("project path: " + baseDir.getAbsolutePath()));
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(FileUtils.file((String)(baseDir.getAbsolutePath() + "/pom.xml")));
        Properties userProperties = this.projectBuildingRequest.getUserProperties();
        String outputPath = baseDir.getAbsolutePath() + "/deps.log." + System.currentTimeMillis();
        List goals = Stream.of("dependency:tree", "-DappendOutput=true", "-DoutputFile=\"" + outputPath + "\"").collect(Collectors.toList());
        if (userProperties != null) {
            userProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                if (key instanceof String && StringUtils.equals((CharSequence)"outputFile", (CharSequence)((String)key))) {
                    return;
                }
                goals.add(String.format("-D%s=%s", key, value));
            }));
        }
        this.getLog().info((CharSequence)("execute 'mvn dependency:tree' with command 'mvn " + String.join((CharSequence)" ", goals) + "'"));
        request.setGoals(goals);
        request.setBatchMode(this.mavenSession.getSettings().getInteractiveMode().booleanValue());
        request.setProfiles(this.mavenSession.getSettings().getActiveProfiles());
        this.setSettingsLocation((InvocationRequest)request);
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("execute dependency:tree failed", (Exception)result.getExecutionException());
            }
            String depTreeStr = org.apache.commons.io.FileUtils.readFileToString((File)org.apache.commons.io.FileUtils.getFile((String[])new String[]{outputPath}), (Charset)Charset.defaultCharset());
            Set<ArtifactItem> set = MavenUtils.convert(depTreeStr);
            return set;
        }
        catch (IOException | MavenInvocationException e) {
            throw new MojoExecutionException("execute dependency:tree failed", (Exception)e);
        }
        finally {
            File outputFile = FileUtils.file((String)outputPath);
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
    }

    private void setSettingsLocation(InvocationRequest request) {
        File globalSettingsFile;
        File userSettingsFile = this.mavenSession.getRequest().getUserSettingsFile();
        if (userSettingsFile != null && userSettingsFile.exists()) {
            request.setUserSettingsFile(userSettingsFile);
        }
        if ((globalSettingsFile = this.mavenSession.getRequest().getGlobalSettingsFile()) != null && globalSettingsFile.exists()) {
            request.setGlobalSettingsFile(globalSettingsFile);
        }
    }

    private Set<Artifact> getAdditionalArtifact() throws MojoExecutionException {
        Artifact arkArtifact = this.repositorySystem.createArtifact(ArkConstants.getGroupId(), ArkConstants.getArtifactId(), this.arkVersion, ArkConstants.getScope(), ArkConstants.getType());
        try {
            ArtifactResolutionRequest artifactResolutionRequest = new ArtifactResolutionRequest();
            artifactResolutionRequest.setArtifact(arkArtifact);
            artifactResolutionRequest.setLocalRepository(this.projectBuildingRequest.getLocalRepository());
            artifactResolutionRequest.setRemoteRepositories(this.mavenProject.getRemoteArtifactRepositories());
            this.repositorySystem.resolve(artifactResolutionRequest);
            HashSet<Artifact> artifacts = new HashSet<Artifact>(Collections.singleton(arkArtifact));
            artifacts.addAll(this.getSlimmedArtifacts());
            return artifacts;
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private Set<Artifact> getSlimmedArtifacts() throws MojoExecutionException, IOException, MojoFailureException {
        if (StringUtils.endsWithAny((CharSequence)this.packExcludesConfig, (CharSequence[])new CharSequence[]{".yml", ".properties"})) {
            throw new MojoExecutionException("not support packExcludesConfig of .yml or .properties in sofa-ark-maven-plugin, please using default conf/ark/bootstrap.yml or conf/ark/bootstrap.properties");
        }
        ModuleSlimConfig moduleSlimConfig = new ModuleSlimConfig().setPackExcludesConfig(this.packExcludesConfig).setPackExcludesUrl(this.packExcludesUrl).setExcludes(this.excludes).setExcludeGroupIds(this.excludeGroupIds).setExcludeArtifactIds(this.excludeArtifactIds).setBaseDependencyParentIdentity(this.baseDependencyParentIdentity);
        ModuleSlimStrategy slimStrategy = new ModuleSlimStrategy(this.mavenProject, this.parseDependencyGraph(), moduleSlimConfig, this.baseDir, this.getLog());
        return slimStrategy.getSlimmedArtifacts();
    }

    private File getAppTargetFile() {
        Object classifier;
        Object object = classifier = this.arkClassifier == null ? "" : this.arkClassifier.trim();
        if (((String)classifier).length() > 0 && !((String)classifier).startsWith("-")) {
            classifier = "-" + (String)classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return new File(this.outputDirectory, this.finalName + (String)classifier + "." + this.mavenProject.getArtifact().getArtifactHandler().getExtension());
    }

    private File getModuleTargetFile() {
        Object classifier;
        Object object = classifier = this.bizClassifier == null ? "" : this.bizClassifier.trim();
        if (((String)classifier).length() > 0 && !((String)classifier).startsWith("-")) {
            classifier = "-" + (String)classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return new File(this.outputDirectory, this.finalName + (String)classifier + "." + this.mavenProject.getArtifact().getArtifactHandler().getExtension());
    }

    private Repackager getRepackager(File source) {
        Repackager repackager = new Repackager(source);
        repackager.addMainClassTimeoutWarningListener((Repackager.MainClassTimeoutWarningListener)new LoggingMainClassTimeoutWarningListener());
        repackager.setMainClass(this.mainClass);
        repackager.setBizName(this.bizName);
        if (!StringUtils.isEmpty((CharSequence)System.getProperty(BIZ_NAME))) {
            repackager.setBizName(System.getProperty(BIZ_NAME));
        }
        repackager.setBizVersion(this.bizVersion);
        repackager.setPriority(String.valueOf(this.priority));
        repackager.setArkVersion(this.arkVersion);
        repackager.setDenyImportClasses(this.denyImportClasses);
        repackager.setDenyImportPackages(this.denyImportPackages);
        repackager.setDenyImportResources(this.denyImportResources);
        repackager.setInjectPluginDependencies(this.injectPluginDependencies);
        repackager.setInjectPluginExportPackages(this.injectPluginExportPackages);
        repackager.setPackageProvided(this.packageProvided);
        repackager.setSkipArkExecutable(this.skipArkExecutable);
        repackager.setKeepArkBizJar(this.keepArkBizJar);
        repackager.setBaseDir(this.baseDir);
        repackager.setWebContextPath(this.webContextPath);
        repackager.setDeclaredMode(this.declaredMode);
        return repackager;
    }

    private void updateArtifact(File repackaged, File modulePackaged) {
        if (this.attach) {
            if (!this.skipArkExecutable) {
                this.attachArtifact(repackaged, this.arkClassifier);
            }
            if (this.keepArkBizJar) {
                this.attachArtifact(modulePackaged, this.bizClassifier);
            }
        }
    }

    private void attachArtifact(File jarFile, String classifier) {
        this.getLog().info((CharSequence)("Attaching archive:" + jarFile + ", with classifier: " + classifier));
        this.projectHelper.attachArtifact(this.mavenProject, this.mavenProject.getPackaging(), classifier, jarFile);
    }

    public void setExcludes(String str) {
        this.excludes = this.parseToSet(str);
    }

    public void setExcludeGroupIds(String str) {
        this.excludeGroupIds = this.parseToSet(str);
    }

    public void setExcludeArtifactIds(String str) {
        this.excludeArtifactIds = this.parseToSet(str);
    }

    public void setDenyImportPackages(String str) {
        this.denyImportPackages = this.parseToSet(str);
    }

    public void setDenyImportClasses(String str) {
        this.denyImportClasses = this.parseToSet(str);
    }

    public void setDenyImportResources(String str) {
        this.denyImportResources = this.parseToSet(str);
    }

    public void setInjectPluginDependencies(String str) {
        this.injectPluginDependencies = this.parseToSet(str);
    }

    public void setInjectPluginExportPackages(String str) {
        this.injectPluginExportPackages = this.parseToSet(str);
    }

    private LinkedHashSet<String> parseToSet(String str) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (StringUtils.isBlank((CharSequence)str)) {
            return set;
        }
        Arrays.stream(str.split(",")).map(String::trim).filter(StringUtils::isNotBlank).forEach(set::add);
        return set;
    }

    public static class ArkConstants {
        private static String groupId = "com.alipay.sofa";
        private static String artifactId = "sofa-ark-all";
        private static String classifier = "";
        private static String scope = "compile";
        private static String type = "jar";

        public static String getGroupId() {
            return groupId;
        }

        public static String getArtifactId() {
            return artifactId;
        }

        public static String getClassifier() {
            return classifier;
        }

        public static String getScope() {
            return scope;
        }

        public static String getType() {
            return type;
        }
    }

    private class LoggingMainClassTimeoutWarningListener
    implements Repackager.MainClassTimeoutWarningListener {
        private LoggingMainClassTimeoutWarningListener() {
        }

        public void handleTimeoutWarning(long duration, String mainMethod) {
            RepackageMojo.this.getLog().warn((CharSequence)String.format("Searching for the main-class is taking some time: %dms, consider using the mainClass configuration parameter", duration));
        }
    }
}

