/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.boot.mojo.model;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.yaml.snakeyaml.Yaml;

public class ArkConfigHolder {
    private static Properties arkProperties;
    private static Map<String, Object> arkYaml;
    private static SystemStreamLog log;

    public static Properties getArkProperties(String baseDir) throws IOException {
        return arkProperties == null ? ArkConfigHolder.initArkProperties(baseDir) : arkProperties;
    }

    public static Map<String, Object> getArkYaml(String baseDir) throws IOException {
        return arkYaml == null ? ArkConfigHolder.initArkYaml(baseDir) : arkYaml;
    }

    private static Map<String, Object> initArkYaml(String baseDir) throws IOException {
        Map<String, Object> map;
        String configPath = baseDir + File.separator + "conf/ark" + File.separator + "bootstrap.yml";
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            log.info((CharSequence)String.format("sofa-ark-maven-plugin: extension-config %s not found, will not config it", configPath));
            return Maps.newHashMap();
        }
        log.info((CharSequence)String.format("sofa-ark-maven-plugin: find extension-config %s and will config it", configPath));
        FileInputStream fis = new FileInputStream(configPath);
        try {
            Yaml yaml = new Yaml();
            arkYaml = (Map)yaml.load((InputStream)fis);
            map = arkYaml;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                log.error((CharSequence)String.format("failed to parse excludes artifacts from %s.", configPath), (Throwable)ex);
                throw ex;
            }
        }
        fis.close();
        return map;
    }

    private static Properties initArkProperties(String baseDir) throws IOException {
        Properties properties;
        String configPath = baseDir + File.separator + "conf/ark" + File.separator + "bootstrap.properties";
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            log.info((CharSequence)String.format("sofa-ark-maven-plugin: extension-config %s not found, will not config it", configPath));
            return new Properties();
        }
        log.info((CharSequence)String.format("sofa-ark-maven-plugin: find extension-config %s and will config it", configPath));
        Properties prop = new Properties();
        FileInputStream fis = new FileInputStream(configPath);
        try {
            prop.load(fis);
            arkProperties = prop;
            properties = prop;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                log.error((CharSequence)String.format("sofa-ark-maven-plugin: failed to read extension-config from %s.", configPath), (Throwable)ex);
                throw ex;
            }
        }
        fis.close();
        return properties;
    }

    static {
        log = new SystemStreamLog();
    }
}

