/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.boot.mojo;

import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.tools.ArtifactItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.project.MavenProject;

public class MavenUtils {
    private static List<String> UN_LOG_SCOPES = Arrays.asList("provided", "test", "import", "system");

    public static boolean isRootProject(MavenProject project) {
        if (project == null) {
            return true;
        }
        return !project.hasParent() || project.getParent().getBasedir() == null;
    }

    public static MavenProject getRootProject(MavenProject project) {
        if (project == null) {
            return null;
        }
        MavenProject parent = project;
        while (parent.hasParent() && parent.getParent().getBasedir() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static Set<ArtifactItem> convert(String depTreeContent) {
        String[] contents;
        HashSet<ArtifactItem> artifactItems = new HashSet<ArtifactItem>();
        for (String content : contents = depTreeContent.split("\n")) {
            ArtifactItem artifactItem = MavenUtils.getArtifactItem(content);
            if (artifactItem == null || "test".equals(artifactItem.getScope())) continue;
            artifactItems.add(artifactItem);
        }
        return artifactItems;
    }

    private static ArtifactItem getArtifactItem(String lineContent) {
        if (StringUtils.isEmpty((String)lineContent)) {
            return null;
        }
        String[] contentInfos = (lineContent = StringUtils.removeCR((String)lineContent)).split(" ");
        if (contentInfos.length == 0) {
            return null;
        }
        Optional<String> artifactStrOp = Arrays.stream(contentInfos).filter(c -> c.contains(":")).findFirst();
        if (!artifactStrOp.isPresent()) {
            return null;
        }
        String[] artifactInfos = artifactStrOp.get().split(":");
        ArtifactItem artifactItem = new ArtifactItem();
        if (artifactInfos.length == 5) {
            artifactItem.setGroupId(artifactInfos[0]);
            artifactItem.setArtifactId(artifactInfos[1]);
            artifactItem.setType(artifactInfos[2]);
            artifactItem.setVersion(artifactInfos[3]);
            artifactItem.setScope(artifactInfos[4]);
        } else if (artifactInfos.length == 6) {
            artifactItem.setGroupId(artifactInfos[0]);
            artifactItem.setArtifactId(artifactInfos[1]);
            artifactItem.setType(artifactInfos[2]);
            artifactItem.setClassifier(artifactInfos[3]);
            artifactItem.setVersion(artifactInfos[4]);
            artifactItem.setScope(artifactInfos[5]);
        } else {
            return null;
        }
        return artifactItem;
    }

    public static boolean inUnLogScopes(String scope) {
        return UN_LOG_SCOPES.contains(scope);
    }
}

