/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.boot.mojo;

import com.alipay.sofa.ark.boot.mojo.MavenUtils;
import com.alipay.sofa.ark.boot.mojo.ModuleSlimConfig;
import com.alipay.sofa.ark.boot.mojo.model.ArkConfigHolder;
import com.alipay.sofa.ark.boot.mojo.utils.ParseUtils;
import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.tools.ArtifactItem;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyNode;

public class ModuleSlimStrategy {
    private MavenProject project;
    private DependencyNode projDependencyGraph;
    private ModuleSlimConfig config;
    private Log log;
    private File baseDir;
    private static final String EXTENSION_EXCLUDE_WITH_INDIRECT_DEPENDENCIES = "excludeWithIndirectDependencies";
    private static final String DEFAULT_EXCLUDE_RULES = "rules.txt";

    ModuleSlimStrategy(MavenProject project, DependencyNode projDependencyGraph, ModuleSlimConfig config, File baseDir, Log log) {
        this.project = project;
        this.projDependencyGraph = projDependencyGraph;
        this.config = config;
        this.baseDir = baseDir;
        this.log = log;
    }

    public Set<Artifact> getSlimmedArtifacts() throws MojoExecutionException, IOException {
        this.initSlimStrategyConfig();
        Set<Artifact> toFilterByBase = this.getArtifactsToFilterByParentIdentity(this.project.getArtifacts());
        Set<Artifact> toFilterByExclude = this.getArtifactsToFilterByExcludeConfig(this.project.getArtifacts());
        Set<Artifact> toAddByInclude = this.getArtifactsToAddByIncludeConfig(this.project.getArtifacts());
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>(this.project.getArtifacts());
        filteredArtifacts.removeAll(toFilterByBase);
        filteredArtifacts.removeAll(toFilterByExclude);
        filteredArtifacts.addAll(toAddByInclude);
        return filteredArtifacts;
    }

    protected Set<Artifact> getArtifactsToFilterByParentIdentity(Set<Artifact> artifacts) throws MojoExecutionException {
        if (StringUtils.isEmpty((CharSequence)this.config.getBaseDependencyParentIdentity())) {
            return Collections.emptySet();
        }
        return this.getSameVersionArtifactsWithBase(artifacts);
    }

    private Set<Artifact> getSameVersionArtifactsWithBase(Set<Artifact> artifacts) throws MojoExecutionException {
        Model baseDependencyPom = this.getBaseDependencyParentOriginalModel();
        if (null == baseDependencyPom) {
            throw new MojoExecutionException(String.format("can not find base dependency parent: %s", this.config.getBaseDependencyParentIdentity()));
        }
        if (null == baseDependencyPom.getDependencyManagement()) {
            return Collections.emptySet();
        }
        List baseDependencies = baseDependencyPom.getDependencyManagement().getDependencies();
        Set dependencyIdentities = baseDependencies.stream().map(this::getDependencyIdentity).collect(Collectors.toSet());
        return artifacts.stream().filter(it -> dependencyIdentities.contains(this.getArtifactIdentity((Artifact)it))).collect(Collectors.toSet());
    }

    private Model getBaseDependencyParentOriginalModel() {
        for (MavenProject proj = this.project; null != proj; proj = proj.getParent()) {
            if (!this.getGAVIdentity(proj.getArtifact()).equals(this.config.getBaseDependencyParentIdentity())) continue;
            return proj.getOriginalModel();
        }
        return null;
    }

    private String getGAVIdentity(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
    }

    protected String getArtifactIdentity(Artifact artifact) {
        if (artifact.hasClassifier()) {
            return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion() + ":" + artifact.getClassifier() + ":" + artifact.getType();
        }
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion() + ":" + artifact.getType();
    }

    private String getDependencyIdentity(Dependency dependency) {
        if (StringUtils.isNotEmpty((CharSequence)dependency.getClassifier())) {
            return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getClassifier() + ":" + dependency.getType();
        }
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getType();
    }

    protected void initSlimStrategyConfig() throws IOException {
        Map<String, Object> arkYaml = ArkConfigHolder.getArkYaml(this.baseDir.getAbsolutePath());
        Properties prop = ArkConfigHolder.getArkProperties(this.baseDir.getAbsolutePath());
        this.config.setExcludeWithIndirectDependencies(ParseUtils.getBooleanWithDefault(prop, EXTENSION_EXCLUDE_WITH_INDIRECT_DEPENDENCIES, true));
        this.config.setExcludeWithIndirectDependencies(ParseUtils.getBooleanWithDefault(arkYaml, EXTENSION_EXCLUDE_WITH_INDIRECT_DEPENDENCIES, true));
        this.initExcludeAndIncludeConfig();
    }

    protected void initExcludeAndIncludeConfig() throws IOException {
        if (!StringUtils.isEmpty((CharSequence)this.config.getPackExcludesConfig())) {
            this.extensionExcludeAndIncludeArtifacts(this.baseDir + File.separator + "conf/ark" + File.separator + this.config.getPackExcludesConfig());
        } else {
            this.extensionExcludeAndIncludeArtifacts(this.baseDir + File.separator + "conf/ark" + File.separator + DEFAULT_EXCLUDE_RULES);
        }
        this.configExcludeArtifactsByDefault();
        if (StringUtils.isNotBlank((CharSequence)this.config.getPackExcludesUrl())) {
            this.extensionExcludeArtifactsFromUrl(this.config.getPackExcludesUrl(), this.project.getArtifacts());
        }
    }

    protected Set<Artifact> getArtifactsToFilterByExcludeConfig(Set<Artifact> artifacts) {
        Set<Artifact> literalArtifactsToExclude = this.getLiteralArtifactsToFilterByExcludeConfig(artifacts);
        if (this.config.isExcludeWithIndirectDependencies()) {
            return this.excludeWithIndirectDependencies(literalArtifactsToExclude, artifacts);
        }
        return literalArtifactsToExclude;
    }

    private Set<Artifact> excludeWithIndirectDependencies(Set<Artifact> literalArtifactsToExclude, Set<Artifact> artifacts) {
        Set<String> excludeArtifactIdentities = literalArtifactsToExclude.stream().map(this::getArtifactIdentity).collect(Collectors.toSet());
        Map<String, Artifact> artifactMap = artifacts.stream().collect(Collectors.toMap(this::getArtifactIdentity, it -> it));
        return this.getExcludeWithIndirectDependencies(this.projDependencyGraph, excludeArtifactIdentities, artifactMap);
    }

    private Set<Artifact> getExcludeWithIndirectDependencies(DependencyNode node, Set<String> literalArtifactsToExclude, Map<String, Artifact> artifacts) {
        if (null == node) {
            return Collections.emptySet();
        }
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        String artifactIdentity = this.getArtifactIdentity(node.getArtifact());
        if (literalArtifactsToExclude.contains(artifactIdentity)) {
            result.add(artifacts.get(artifactIdentity));
            result.addAll(this.getAllDependencies(node, artifacts));
            return result;
        }
        for (DependencyNode child : node.getChildren()) {
            result.addAll(this.getExcludeWithIndirectDependencies(child, literalArtifactsToExclude, artifacts));
        }
        return result;
    }

    private Set<Artifact> getAllDependencies(DependencyNode node, Map<String, Artifact> artifacts) {
        if (null == node) {
            return Collections.emptySet();
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (DependencyNode child : node.getChildren()) {
            result.add(artifacts.get(this.getArtifactIdentity(child.getArtifact())));
            result.addAll(this.getAllDependencies(child, artifacts));
        }
        return result;
    }

    protected Set<Artifact> getLiteralArtifactsToFilterByExcludeConfig(Set<Artifact> artifacts) {
        ArrayList<ArtifactItem> excludeList = new ArrayList<ArtifactItem>();
        if (this.config != null && (this.config.getExcludes().contains("*") || this.config.getExcludes().contains(".*"))) {
            return artifacts;
        }
        for (String exclude : this.config.getExcludes()) {
            ArtifactItem item = ArtifactItem.parseArtifactItem((String)exclude);
            excludeList.add(item);
        }
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact e : artifacts) {
            if (!this.checkMatchExclude(excludeList, e)) continue;
            result.add(e);
        }
        return result;
    }

    protected Set<Artifact> getArtifactsToAddByIncludeConfig(Set<Artifact> artifacts) {
        ArrayList<ArtifactItem> includeList = new ArrayList<ArtifactItem>();
        if (this.config != null && (this.config.getIncludes().contains("*") || this.config.getIncludes().contains(".*"))) {
            return artifacts;
        }
        for (String include : this.config.getIncludes()) {
            ArtifactItem item = ArtifactItem.parseArtifactItem((String)include);
            includeList.add(item);
        }
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact e : artifacts) {
            if (!this.checkMatchInclude(includeList, e)) continue;
            result.add(e);
        }
        return result;
    }

    private boolean checkMatchExclude(List<ArtifactItem> excludeList, Artifact artifact) {
        for (ArtifactItem exclude : excludeList) {
            if (!exclude.isSameWithVersion(ArtifactItem.parseArtifactItem((Artifact)artifact))) continue;
            return true;
        }
        if (this.checkMatchGroupId(this.config.getExcludeGroupIds(), artifact)) {
            return true;
        }
        return this.checkMatchArtifactId(this.config.getExcludeArtifactIds(), artifact);
    }

    private boolean checkMatchInclude(List<ArtifactItem> includeList, Artifact artifact) {
        for (ArtifactItem include : includeList) {
            if (!include.isSameWithVersion(ArtifactItem.parseArtifactItem((Artifact)artifact))) continue;
            return true;
        }
        if (this.checkMatchGroupId(this.config.getIncludeGroupIds(), artifact)) {
            return true;
        }
        return this.checkMatchArtifactId(this.config.getIncludeArtifactIds(), artifact);
    }

    private boolean checkMatchGroupId(Set<String> groupIds, Artifact artifact) {
        if (groupIds != null) {
            for (String groupId : groupIds) {
                if (groupId.endsWith("*") || groupId.endsWith(".*")) {
                    if (groupId.endsWith(".*")) {
                        groupId = StringUtils.removeEnd((String)groupId, (String)".*");
                    } else if (groupId.endsWith("*")) {
                        groupId = StringUtils.removeEnd((String)groupId, (String)"*");
                    }
                    if (!artifact.getGroupId().startsWith(groupId)) continue;
                    return true;
                }
                if (!artifact.getGroupId().equals(groupId)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatchArtifactId(Set<String> artifactIds, Artifact artifact) {
        if (artifactIds != null) {
            for (String artifactId : artifactIds) {
                if (artifactId.endsWith("*") || artifactId.endsWith(".*")) {
                    if (artifactId.endsWith(".*")) {
                        artifactId = StringUtils.removeEnd((String)artifactId, (String)".*");
                    } else if (artifactId.endsWith("*")) {
                        artifactId = StringUtils.removeEnd((String)artifactId, (String)"*");
                    }
                    if (!artifact.getArtifactId().startsWith(artifactId)) continue;
                    return true;
                }
                if (!artifact.getArtifactId().equals(artifactId)) continue;
                return true;
            }
        }
        return false;
    }

    protected void extensionExcludeAndIncludeArtifacts(String extraResources) {
        try {
            File configFile = FileUtils.file((String)extraResources);
            if (configFile.exists()) {
                String dataLine;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
                while ((dataLine = bufferedReader.readLine()) != null) {
                    if (dataLine.startsWith("excludes")) {
                        com.alipay.sofa.ark.common.util.ParseUtils.parseExcludeConf(this.config.getExcludes(), (String)dataLine, (String)"excludes");
                        continue;
                    }
                    if (dataLine.startsWith("excludeGroupIds")) {
                        com.alipay.sofa.ark.common.util.ParseUtils.parseExcludeConf(this.config.getExcludeGroupIds(), (String)dataLine, (String)"excludeGroupIds");
                        continue;
                    }
                    if (dataLine.startsWith("excludeArtifactIds")) {
                        com.alipay.sofa.ark.common.util.ParseUtils.parseExcludeConf(this.config.getExcludeArtifactIds(), (String)dataLine, (String)"excludeArtifactIds");
                        continue;
                    }
                    if (dataLine.startsWith("includes")) {
                        com.alipay.sofa.ark.common.util.ParseUtils.parseExcludeConf(this.config.getIncludes(), (String)dataLine, (String)"includes");
                        continue;
                    }
                    if (dataLine.startsWith("includeGroupIds")) {
                        com.alipay.sofa.ark.common.util.ParseUtils.parseExcludeConf(this.config.getIncludeGroupIds(), (String)dataLine, (String)"includeGroupIds");
                        continue;
                    }
                    if (!dataLine.startsWith("includeArtifactIds")) continue;
                    com.alipay.sofa.ark.common.util.ParseUtils.parseExcludeConf(this.config.getIncludeArtifactIds(), (String)dataLine, (String)"includeArtifactIds");
                }
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"failed to extension excludes artifacts.", (Throwable)ex);
        }
    }

    protected void configExcludeArtifactsByDefault() throws IOException {
        Map<String, Object> arkYaml = ArkConfigHolder.getArkYaml(this.baseDir.getAbsolutePath());
        Properties prop = ArkConfigHolder.getArkProperties(this.baseDir.getAbsolutePath());
        this.config.getExcludes().addAll(ParseUtils.getStringSet(prop, "excludes"));
        this.config.getExcludeGroupIds().addAll(ParseUtils.getStringSet(prop, "excludeGroupIds"));
        this.config.getExcludeArtifactIds().addAll(ParseUtils.getStringSet(prop, "excludeArtifactIds"));
        this.config.getIncludes().addAll(ParseUtils.getStringSet(prop, "includes"));
        this.config.getIncludeGroupIds().addAll(ParseUtils.getStringSet(prop, "includeGroupIds"));
        this.config.getIncludeArtifactIds().addAll(ParseUtils.getStringSet(prop, "includeArtifactIds"));
        this.config.getExcludes().addAll(ParseUtils.getStringSet(arkYaml, "excludes"));
        this.config.getExcludeGroupIds().addAll(ParseUtils.getStringSet(arkYaml, "excludeGroupIds"));
        this.config.getExcludeArtifactIds().addAll(ParseUtils.getStringSet(arkYaml, "excludeArtifactIds"));
        this.config.getIncludes().addAll(ParseUtils.getStringSet(arkYaml, "includes"));
        this.config.getIncludeGroupIds().addAll(ParseUtils.getStringSet(arkYaml, "includeGroupIds"));
        this.config.getIncludeArtifactIds().addAll(ParseUtils.getStringSet(arkYaml, "includeArtifactIds"));
    }

    protected void extensionExcludeArtifactsFromUrl(String packExcludesUrl, Set<Artifact> artifacts) {
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            HttpGet request = new HttpGet(packExcludesUrl);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200 && response.getEntity() != null) {
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                this.getLog().info((CharSequence)String.format("success to get excludes config from url: %s, response: %s", packExcludesUrl, result));
                ObjectMapper objectMapper = new ObjectMapper();
                ExcludeConfigResponse excludeConfigResponse = (ExcludeConfigResponse)objectMapper.readValue(result, ExcludeConfigResponse.class);
                if (excludeConfigResponse.isSuccess() && excludeConfigResponse.getResult() != null) {
                    ExcludeConfig excludeConfig = excludeConfigResponse.getResult();
                    List<String> jarBlackGroupIds = excludeConfig.getJarBlackGroupIds();
                    List<String> jarBlackArtifactIds = excludeConfig.getJarBlackArtifactIds();
                    List<String> jarBlackList = excludeConfig.getJarBlackList();
                    List<String> jarWhiteGroupIds = excludeConfig.getJarWhiteGroupIds();
                    List<String> jarWhiteArtifactIds = excludeConfig.getJarWhiteArtifactIds();
                    List<String> jarWhiteList = excludeConfig.getJarWhiteList();
                    if (CollectionUtils.isNotEmpty(jarBlackGroupIds)) {
                        this.config.getExcludeGroupIds().addAll(jarBlackGroupIds);
                    }
                    if (CollectionUtils.isNotEmpty(jarBlackArtifactIds)) {
                        this.config.getExcludeArtifactIds().addAll(jarBlackArtifactIds);
                    }
                    if (CollectionUtils.isNotEmpty(jarBlackList)) {
                        this.config.getExcludes().addAll(jarBlackList);
                    }
                    if (CollectionUtils.isNotEmpty(jarWhiteGroupIds)) {
                        this.config.getIncludeGroupIds().addAll(jarWhiteGroupIds);
                    }
                    if (CollectionUtils.isNotEmpty(jarWhiteArtifactIds)) {
                        this.config.getIncludeArtifactIds().addAll(jarWhiteArtifactIds);
                    }
                    if (CollectionUtils.isNotEmpty(jarWhiteList)) {
                        this.config.getIncludes().addAll(jarWhiteList);
                    }
                    this.logExcludeMessage(jarBlackGroupIds, jarBlackArtifactIds, jarBlackList, artifacts, true);
                    List<String> jarWarnGroupIds = excludeConfig.getJarWarnGroupIds();
                    List<String> jarWarnArtifactIds = excludeConfig.getJarWarnArtifactIds();
                    List<String> jarWarnList = excludeConfig.getJarWarnList();
                    this.logExcludeMessage(jarWarnGroupIds, jarWarnArtifactIds, jarWarnList, artifacts, false);
                }
            }
            response.close();
            client.close();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("failed to get excludes config from url: %s", packExcludesUrl), (Throwable)e);
        }
    }

    protected void logExcludeMessage(List<String> jarGroupIds, List<String> jarArtifactIds, List<String> jarList, Set<Artifact> artifacts, boolean error) {
        if (CollectionUtils.isNotEmpty(jarGroupIds)) {
            for (Artifact artifact : artifacts) {
                if (MavenUtils.inUnLogScopes(artifact.getScope())) continue;
                for (String jarBlackGroupId : jarGroupIds) {
                    if (jarBlackGroupId.endsWith("*") || jarBlackGroupId.endsWith(".*")) {
                        if (jarBlackGroupId.endsWith(".*")) {
                            jarBlackGroupId = StringUtils.remove((String)jarBlackGroupId, (String)".*");
                        } else if (jarBlackGroupId.endsWith("*")) {
                            jarBlackGroupId = StringUtils.removeEnd((String)jarBlackGroupId, (String)"*");
                        }
                        if (!artifact.getGroupId().startsWith(jarBlackGroupId)) continue;
                        if (error) {
                            this.getLog().error((CharSequence)String.format("Error to package jar: %s due to match groupId: %s, automatically exclude it.", artifact, jarBlackGroupId));
                            continue;
                        }
                        this.getLog().warn((CharSequence)String.format("Warn to package jar: %s due to match groupId: %s", artifact, jarBlackGroupId));
                        continue;
                    }
                    if (!artifact.getGroupId().equals(jarBlackGroupId)) continue;
                    if (error) {
                        this.getLog().error((CharSequence)String.format("Error to package jar: %s due to match groupId: %s, automatically exclude it.", artifact, jarBlackGroupId));
                        continue;
                    }
                    this.getLog().warn((CharSequence)String.format("Warn to package jar: %s due to match groupId: %s", artifact, jarBlackGroupId));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(jarArtifactIds)) {
            for (Artifact artifact : artifacts) {
                if (MavenUtils.inUnLogScopes(artifact.getScope())) continue;
                for (String jarBlackArtifactId : jarArtifactIds) {
                    if (jarBlackArtifactId.endsWith("*") || jarBlackArtifactId.endsWith(".*")) {
                        if (jarBlackArtifactId.endsWith(".*")) {
                            jarBlackArtifactId = StringUtils.removeEnd((String)jarBlackArtifactId, (String)".*");
                        } else if (jarBlackArtifactId.endsWith("*")) {
                            jarBlackArtifactId = StringUtils.removeEnd((String)jarBlackArtifactId, (String)"*");
                        }
                        if (!artifact.getArtifactId().startsWith(jarBlackArtifactId)) continue;
                        if (error) {
                            this.getLog().error((CharSequence)String.format("Error to package jar: %s due to match artifactId: %s, automatically exclude it.", artifact, jarBlackArtifactId));
                            continue;
                        }
                        this.getLog().warn((CharSequence)String.format("Warn to package jar: %s due to match artifactId: %s", artifact, jarBlackArtifactId));
                        continue;
                    }
                    if (!artifact.getArtifactId().equals(jarBlackArtifactId)) continue;
                    if (error) {
                        this.getLog().error((CharSequence)String.format("Error to package jar: %s due to match artifactId: %s, automatically exclude it.", artifact, jarBlackArtifactId));
                        continue;
                    }
                    this.getLog().warn((CharSequence)String.format("Warn to package jar: %s due to match artifactId: %s", artifact, jarBlackArtifactId));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(jarList)) {
            for (Artifact artifact : artifacts) {
                if (MavenUtils.inUnLogScopes(artifact.getScope())) continue;
                for (String jarBlack : jarList) {
                    if (!jarBlack.equals(String.join((CharSequence)":", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()))) continue;
                    if (error) {
                        this.getLog().error((CharSequence)String.format("Error to package jar: %s due to match groupId:artifactId:version: %s, automatically exclude it.", artifact, jarBlack));
                        continue;
                    }
                    this.getLog().warn((CharSequence)String.format("Warn to package jar: %s due to match groupId:artifactId:version: %s", artifact, jarBlack));
                }
            }
        }
    }

    private Log getLog() {
        return this.log;
    }

    public static class ExcludeConfigResponse {
        private boolean success;
        private ExcludeConfig result;

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public ExcludeConfig getResult() {
            return this.result;
        }

        public void setResult(ExcludeConfig result) {
            this.result = result;
        }
    }

    public static class ExcludeConfig {
        private String app;
        private List<String> jarBlackGroupIds;
        private List<String> jarBlackArtifactIds;
        private List<String> jarBlackList;
        private List<String> JarWhiteGroupIds;
        private List<String> jarWhiteArtifactIds;
        private List<String> jarWhiteList;
        private List<String> jarWarnGroupIds;
        private List<String> jarWarnArtifactIds;
        private List<String> jarWarnList;

        public String getApp() {
            return this.app;
        }

        public void setApp(String app) {
            this.app = app;
        }

        public List<String> getJarBlackGroupIds() {
            return this.jarBlackGroupIds;
        }

        public void setJarBlackGroupIds(List<String> jarBlackGroupIds) {
            this.jarBlackGroupIds = jarBlackGroupIds;
        }

        public List<String> getJarBlackArtifactIds() {
            return this.jarBlackArtifactIds;
        }

        public void setJarBlackArtifactIds(List<String> jarBlackArtifactIds) {
            this.jarBlackArtifactIds = jarBlackArtifactIds;
        }

        public List<String> getJarBlackList() {
            return this.jarBlackList;
        }

        public void setJarBlackList(List<String> jarBlackList) {
            this.jarBlackList = jarBlackList;
        }

        public List<String> getJarWhiteGroupIds() {
            return this.JarWhiteGroupIds;
        }

        public void setJarWhiteGroupIds(List<String> jarWhiteGroupIds) {
            this.JarWhiteGroupIds = jarWhiteGroupIds;
        }

        public List<String> getJarWhiteArtifactIds() {
            return this.jarWhiteArtifactIds;
        }

        public void setJarWhiteArtifactIds(List<String> jarWhiteArtifactIds) {
            this.jarWhiteArtifactIds = jarWhiteArtifactIds;
        }

        public List<String> getJarWhiteList() {
            return this.jarWhiteList;
        }

        public void setJarWhiteList(List<String> jarWhiteList) {
            this.jarWhiteList = jarWhiteList;
        }

        public List<String> getJarWarnGroupIds() {
            return this.jarWarnGroupIds;
        }

        public void setJarWarnGroupIds(List<String> jarWarnGroupIds) {
            this.jarWarnGroupIds = jarWarnGroupIds;
        }

        public List<String> getJarWarnArtifactIds() {
            return this.jarWarnArtifactIds;
        }

        public void setJarWarnArtifactIds(List<String> jarWarnArtifactIds) {
            this.jarWarnArtifactIds = jarWarnArtifactIds;
        }

        public List<String> getJarWarnList() {
            return this.jarWarnList;
        }

        public void setJarWarnList(List<String> jarWarnList) {
            this.jarWarnList = jarWarnList;
        }
    }
}

