/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.boot.mojo.utils;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ParseUtils {
    public static Set<String> getStringSet(Properties prop, String confKey) {
        if (null == prop) {
            return Sets.newHashSet();
        }
        Object[] values = StringUtils.split((String)prop.getProperty(confKey), (String)",");
        if (values == null) {
            return Sets.newHashSet();
        }
        values = (String[])Arrays.stream(values).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
        return Sets.newHashSet((Object[])values);
    }

    public static Set<String> getStringSet(Map<String, Object> yaml, String confKey) {
        Object value = ParseUtils.getValue(yaml, confKey);
        if (null == value) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet((Iterable)((List)value));
    }

    public static boolean getBooleanWithDefault(Map<String, Object> yaml, String confKey, boolean defaultValue) {
        Object value = ParseUtils.getValue(yaml, confKey);
        if (null == value) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public static boolean getBooleanWithDefault(Properties prop, String confKey, boolean defaultValue) {
        String value = prop.getProperty(confKey);
        if (null == value) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private static Object getValue(Map<String, Object> yaml, String confKey) {
        if (MapUtils.isEmpty(yaml) || StringUtils.isEmpty((CharSequence)confKey)) {
            return null;
        }
        List<String> keys = Arrays.asList(StringUtils.split((String)confKey, (String)"."));
        String currentKey = keys.get(0);
        if (yaml.containsKey(currentKey) && null != yaml.get(currentKey) && keys.size() == 1) {
            return yaml.get(currentKey);
        }
        if (yaml.containsKey(currentKey) && null != yaml.get(currentKey) && keys.size() > 1 && yaml.get(currentKey) instanceof Map) {
            return ParseUtils.getValue((Map)yaml.get(currentKey), StringUtils.join(keys.subList(1, keys.size()), (String)"."));
        }
        return null;
    }
}

