/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.plugin.mojo;

import com.alipay.sofa.ark.common.util.ClassUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.plugin.mojo.ExportConfig;
import com.alipay.sofa.ark.plugin.mojo.ImportConfig;
import com.alipay.sofa.ark.plugin.mojo.LinkedManifest;
import com.alipay.sofa.ark.plugin.mojo.LinkedProperties;
import com.alipay.sofa.ark.tools.ArtifactItem;
import com.alipay.sofa.ark.tools.JarWriter;
import com.alipay.sofa.ark.tools.Repackager;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.AbstractZipArchiver;

@Mojo(name="ark-plugin", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ArkPluginMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Component
    protected ArchiverManager archiverManager;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}", property="sofa.ark.plugin.repository")
    protected File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/sofa-ark-maven-plugin")
    protected File workDirectory;
    @Parameter(defaultValue="${project.groupId}", readonly=true)
    protected String groupId;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    protected String artifactId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    protected String version;
    @Parameter(defaultValue="${project.artifactId}")
    public String pluginName;
    @Parameter(defaultValue=" ")
    protected String description;
    @Parameter(defaultValue="100", property="sofa.ark.plugin.priority")
    protected Integer priority;
    @Parameter
    protected String activator;
    @Parameter
    protected ExportConfig exported;
    @Parameter
    protected ImportConfig imported;
    @Parameter(defaultValue="")
    protected LinkedHashSet<String> excludes = new LinkedHashSet();
    @Parameter(defaultValue="")
    protected LinkedHashSet<String> excludeGroupIds;
    @Parameter(defaultValue="")
    protected LinkedHashSet<String> excludeArtifactIds;
    @Parameter(defaultValue="")
    protected LinkedHashSet<String> shades = new LinkedHashSet();
    @Parameter(defaultValue="true")
    private Boolean attach;
    @Parameter(defaultValue="")
    private String classifier;
    @Parameter(defaultValue="true")
    protected Boolean exportPluginClass;
    private static final String ARCHIVE_MODE = "zip";
    private static final String PLUGIN_SUFFIX = ".ark.plugin";
    private static final String TEMP_PLUGIN_SUFFIX = ".ark.plugin.bak";

    public void execute() throws MojoExecutionException {
        Archiver archiver;
        try {
            archiver = this.getArchiver();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        String fileName = this.getFileName();
        File destination = new File(this.outputDirectory, fileName);
        File tmpDestination = new File(this.outputDirectory, this.getTempFileName());
        if (destination.exists()) {
            destination.delete();
        }
        if (tmpDestination.exists()) {
            tmpDestination.delete();
        }
        archiver.setDestFile(tmpDestination);
        Set<Artifact> artifacts = this.project.getArtifacts();
        artifacts = this.filterExcludeArtifacts(artifacts);
        Set<Artifact> conflictArtifacts = this.filterConflictArtifacts(artifacts);
        this.addArkPluginArtifact(archiver, artifacts, conflictArtifacts);
        this.addArkPluginConfig(archiver);
        try {
            archiver.createArchive();
            this.shadeJarIntoArkPlugin(destination, tmpDestination, artifacts);
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            tmpDestination.delete();
        }
        if (this.isAttach()) {
            if (StringUtils.isEmpty((String)this.classifier)) {
                Artifact artifact = this.project.getArtifact();
                artifact.setFile(destination);
                this.project.setArtifact(artifact);
            } else {
                this.projectHelper.attachArtifact(this.project, destination, this.classifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shadeJarIntoArkPlugin(File pluginFile, File tmpPluginFile, Set<Artifact> artifacts) throws IOException {
        HashSet<Artifact> shadeJars = new HashSet<Artifact>();
        shadeJars.add(this.project.getArtifact());
        for (Artifact artifact : artifacts) {
            if (!this.isShadeJar(artifact)) continue;
            shadeJars.add(artifact);
        }
        JarWriter writer = new JarWriter(pluginFile);
        JarFile tmpJarFile = new JarFile(tmpPluginFile);
        try {
            writer.writeEntries(tmpJarFile);
            for (Artifact jar : shadeJars) {
                writer.writeEntries(new JarFile(jar.getFile()));
            }
        }
        finally {
            writer.close();
            tmpJarFile.close();
        }
    }

    public LinkedHashSet<String> getShades() {
        return this.shades;
    }

    public void setShades(LinkedHashSet<String> shades) {
        this.shades = shades;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isShadeJar(Artifact artifact) {
        for (String shade : this.getShades()) {
            ArtifactItem artifactItem = ArtifactItem.parseArtifactItemWithVersion((String)shade);
            if (!artifact.getGroupId().equals(artifactItem.getGroupId()) || !artifact.getArtifactId().equals(artifactItem.getArtifactId()) || !artifact.getVersion().equals(artifactItem.getVersion()) || !StringUtils.isEmpty((String)artifactItem.getClassifier()) && !artifactItem.getClassifier().equals(artifact.getClassifier())) continue;
            if (artifact.getArtifactId().equals(this.project.getArtifactId()) && artifact.getGroupId().equals(this.project.getGroupId())) {
                throw new RuntimeException("Can't shade jar-self.");
            }
            return true;
        }
        return false;
    }

    protected void addArkPluginArtifact(Archiver archiver, Set<Artifact> dependencies, Set<Artifact> conflicts) {
        for (Artifact artifact : dependencies) {
            if (!Repackager.isZip((File)artifact.getFile())) continue;
            this.addArtifact(archiver, artifact, conflicts.contains(artifact));
        }
    }

    protected void addArtifact(Archiver archiver, Artifact artifact, boolean artifactIdConflict) {
        if (this.isShadeJar(artifact)) {
            return;
        }
        String destination = artifact.getFile().getName();
        if (artifactIdConflict) {
            destination = artifact.getGroupId() + "-" + destination;
        }
        destination = "lib/" + destination;
        this.getLog().debug((CharSequence)("  " + artifact + " => " + destination));
        archiver.addFile(artifact.getFile(), destination);
    }

    protected Set<Artifact> filterConflictArtifacts(Set<Artifact> artifacts) {
        HashMap<String, Artifact> existArtifacts = new HashMap<String, Artifact>(Collections.singletonMap(this.project.getArtifact().getArtifactId(), this.project.getArtifact()));
        HashSet<Artifact> conflictArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (existArtifacts.containsKey(artifact.getArtifactId())) {
                conflictArtifacts.add(artifact);
                conflictArtifacts.add(existArtifacts.get(artifact.getArtifactId()));
                continue;
            }
            existArtifacts.put(artifact.getArtifactId(), artifact);
        }
        return conflictArtifacts;
    }

    protected Set<Artifact> filterExcludeArtifacts(Set<Artifact> artifacts) {
        ArrayList<ArtifactItem> excludeList = new ArrayList<ArtifactItem>();
        for (String exclude : this.excludes) {
            ArtifactItem item = ArtifactItem.parseArtifactItemIgnoreVersion((String)exclude);
            excludeList.add(item);
        }
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact e : artifacts) {
            boolean isExclude = false;
            for (ArtifactItem exclude : excludeList) {
                if (!exclude.isSameIgnoreVersion(ArtifactItem.parseArtifactItem((Artifact)e))) continue;
                isExclude = true;
                break;
            }
            if (this.excludeGroupIds != null && this.excludeGroupIds.contains(e.getGroupId())) {
                isExclude = true;
            }
            if (this.excludeArtifactIds != null && this.excludeArtifactIds.contains(e.getArtifactId())) {
                isExclude = true;
            }
            if (isExclude) continue;
            result.add(e);
        }
        return result;
    }

    protected Archiver getArchiver() throws NoSuchArchiverException {
        Archiver archiver = this.archiverManager.getArchiver(ARCHIVE_MODE);
        ((AbstractZipArchiver)archiver).setCompress(false);
        return archiver;
    }

    protected String getFileName() {
        return String.format("%s%s", this.pluginName, PLUGIN_SUFFIX);
    }

    protected String getTempFileName() {
        return String.format("%s%s", this.pluginName, TEMP_PLUGIN_SUFFIX);
    }

    protected boolean isAttach() {
        return this.attach;
    }

    protected boolean getExportPluginClass() {
        return this.exportPluginClass;
    }

    protected void addArkPluginConfig(Archiver archiver) throws MojoExecutionException {
        this.addManifest(archiver);
        this.addArkPluginMark(archiver);
    }

    private void addManifest(Archiver archiver) throws MojoExecutionException {
        LinkedProperties properties = new LinkedProperties();
        properties.setProperty("groupId", this.groupId);
        properties.setProperty("artifactId", this.artifactId);
        properties.setProperty("version", this.version);
        properties.setProperty("priority", String.valueOf(this.priority));
        properties.setProperty("pluginName", this.pluginName);
        properties.setProperty("description", this.description);
        properties.setProperty("activator", this.activator == null ? "" : this.activator);
        properties.putAll((Map<?, ?>)this.collectArkPluginImport());
        properties.putAll((Map<?, ?>)this.collectArkPluginExport());
        this.addArkPluginConfig(archiver, "META-INF/MANIFEST.MF", properties);
    }

    private Properties collectArkPluginExport() throws MojoExecutionException {
        LinkedProperties properties = new LinkedProperties();
        if (this.exported == null) {
            this.exported = new ExportConfig();
        }
        if (this.exportPluginClass.booleanValue()) {
            Set<String> projectClasses = this.findProjectClasses();
            for (String projectClass : projectClasses) {
                if (StringUtils.isEmpty((String)projectClass)) continue;
                this.exported.addClass(projectClass);
            }
        }
        this.exported.store(properties);
        return properties;
    }

    private Set<String> findProjectClasses() throws MojoExecutionException {
        try {
            File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
            if (outputDirectory.exists()) {
                HashSet<String> classes = new HashSet(ClassUtils.collectClasses((File)outputDirectory));
                classes = classes.stream().filter(className -> !className.equals(this.activator)).collect(Collectors.toSet());
                return classes;
            }
            this.getLog().warn((CharSequence)"Output directory does not exist!");
            return new HashSet<String>();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error finding compiled classes", (Exception)e);
        }
    }

    private Properties collectArkPluginImport() {
        LinkedProperties properties = new LinkedProperties();
        if (this.imported == null) {
            this.imported = new ImportConfig();
        }
        this.imported.store(properties);
        return properties;
    }

    private void addArkPluginConfig(Archiver archiver, String path, LinkedProperties properties) throws MojoExecutionException {
        File file = new File(this.workDirectory.getPath() + File.separator + path);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        PrintStream outputStream = null;
        LinkedManifest manifest = new LinkedManifest();
        ((Manifest)manifest).getMainAttributes().putValue("Manifest-Version", "1.0");
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            ((Manifest)manifest).getMainAttributes().putValue(key, properties.getProperty(key));
        }
        try {
            outputStream = new PrintStream(file, "UTF-8");
            ((Manifest)manifest).write(outputStream);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        archiver.addFile(file, path);
    }

    private void addArkPluginMark(Archiver archiver) throws MojoExecutionException {
        this.addArkPluginConfig(archiver, "com/alipay/sofa/ark/plugin/mark", new LinkedProperties());
    }
}

