/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.spi.model;

import com.alipay.sofa.ark.spi.model.BizState;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public interface BizInfo {
    public String getBizName();

    public String getBizVersion();

    public String getIdentity();

    public String getMainClass();

    public URL[] getClassPath();

    public URL getBizUrl();

    public Set<String> getDenyImportPackages();

    public Set<String> getDenyImportPackageNodes();

    public Set<String> getDenyImportPackageStems();

    public Set<String> getDenyImportClasses();

    public Set<String> getDenyImportResources();

    public Set<String> getDenyPrefixImportResourceStems();

    public Set<String> getDenySuffixImportResourceStems();

    public ClassLoader getBizClassLoader();

    public BizState getBizState();

    public String getWebContextPath();

    public Map<String, String> getAttributes();

    public List<BizStateRecord> getBizStateRecords();

    public static enum StateChangeReason {
        CREATED("Created"),
        STARTED("Started"),
        INSTALL_FAILED("Install Failed"),
        UN_INSTALL_FAILED("Uninstall Failed"),
        SWITCHED("Switched"),
        KILLING("Killing"),
        STOPPED("Stopped"),
        UNDEFINE("Undefine");

        private final String reason;

        private StateChangeReason(String reason) {
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return this.getReason();
        }
    }

    public static class BizStateRecord {
        private final Date changeTime;
        private final BizState state;
        private final StateChangeReason reason;
        private final String message;
        private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public BizStateRecord(Date changeTime, BizState state) {
            this.changeTime = changeTime;
            this.state = state;
            this.reason = StateChangeReason.UNDEFINE;
            this.message = "";
        }

        public BizStateRecord(Date changeTime, BizState state, StateChangeReason reason, String message) {
            this.changeTime = changeTime;
            this.state = state;
            this.reason = reason;
            this.message = message;
        }

        public String toString() {
            String date = sdf.format(this.changeTime);
            return String.format("%s -> %s with reason: %s and message: %s", new Object[]{date, this.state, this.reason, this.message});
        }

        public Date getChangeTime() {
            return this.changeTime;
        }

        public BizState getState() {
            return this.state;
        }

        public StateChangeReason getReason() {
            return this.reason;
        }

        public String getMessage() {
            return this.message;
        }

        static {
            sdf.setTimeZone(TimeZone.getDefault());
        }
    }
}

