/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.listener;

import com.alipay.sofa.ark.support.startup.SofaArkBootstrap;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationListener;

public class ArkApplicationStartListener
implements ApplicationListener<SpringApplicationEvent> {
    private static final String LAUNCH_CLASSLOADER_NAME = "sun.misc.Launcher$AppClassLoader";
    private static final String APPLICATION_STARTED_EVENT = "org.springframework.boot.context.event.ApplicationStartedEvent";
    private static final String APPLICATION_STARTING_EVENT = "org.springframework.boot.context.event.ApplicationStartingEvent";

    public void onApplicationEvent(SpringApplicationEvent event) {
        try {
            if (this.isSpringBoot2() && APPLICATION_STARTING_EVENT.equals(event.getClass().getCanonicalName())) {
                this.startUpArk(event);
            }
            if (this.isSpringBoot1() && APPLICATION_STARTED_EVENT.equals(event.getClass().getCanonicalName())) {
                this.startUpArk(event);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Meet exception when determine whether to start SOFAArk!", e);
        }
    }

    public void startUpArk(SpringApplicationEvent event) {
        if (LAUNCH_CLASSLOADER_NAME.equals(this.getClass().getClassLoader().getClass().getName())) {
            SofaArkBootstrap.launch((String[])event.getArgs());
        }
    }

    public boolean isSpringBoot1() {
        return SpringBootVersion.getVersion().startsWith("1");
    }

    public boolean isSpringBoot2() {
        return SpringBootVersion.getVersion().startsWith("2");
    }
}

