/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.startup;

import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.bootstrap.ClasspathLauncher;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.loader.EmbedClassPathArchive;
import com.alipay.sofa.ark.support.common.DelegateToMasterBizClassLoaderHook;
import com.alipay.sofa.ark.support.startup.EntryMethod;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.core.env.Environment;

public class EmbedSofaArkBootstrap {
    private static AtomicBoolean started = new AtomicBoolean(false);
    static Object arkContainer;

    public static void launch(Environment environment) {
        if (started.compareAndSet(false, true)) {
            EntryMethod entryMethod = new EntryMethod(Thread.currentThread());
            EmbedSofaArkBootstrap.getOrSetDefault("com.alipay.sofa.ark.master.biz", environment.getProperty("com.alipay.sofa.ark.master.biz", environment.getProperty("spring.application.name", "master biz")));
            EmbedSofaArkBootstrap.getOrSetDefault("com.alipay.sofa.ark.biz.classloader.hook.dir", environment.getProperty("com.alipay.sofa.ark.biz.classloader.hook.dir"));
            EmbedSofaArkBootstrap.getOrSetDefault("sofa.ark.plugin.export.class.enable", environment.getProperty("sofa.ark.plugin.export.class.enable", "false"));
            EmbedSofaArkBootstrap.getOrSetDefault("com.alipay.sofa.ark.biz.classloader.hook.dir", DelegateToMasterBizClassLoaderHook.class.getName());
            try {
                URL[] urls = EmbedSofaArkBootstrap.getURLClassPath();
                ClasspathLauncher launcher = new ClasspathLauncher((ClasspathLauncher.ClassPathArchive)new EmbedClassPathArchive(entryMethod.getDeclaringClassName(), entryMethod.getMethod().getName(), urls));
                arkContainer = launcher.launch(new String[0], EmbedSofaArkBootstrap.getClasspath(urls), entryMethod.getMethod());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void getOrSetDefault(String key, String defaultValue) {
        String value = ArkConfigs.getStringValue((String)key);
        if (value == null && defaultValue != null) {
            ArkConfigs.setSystemProperty((String)key, (String)defaultValue);
        }
    }

    private static String getClasspath(URL[] urls) {
        StringBuilder sb = new StringBuilder();
        for (URL url : urls) {
            sb.append(url.toExternalForm()).append(",");
        }
        return sb.toString();
    }

    private static URL[] getURLClassPath() {
        ClassLoader classLoader = EmbedSofaArkBootstrap.class.getClassLoader();
        return ClassLoaderUtils.getURLs((ClassLoader)classLoader);
    }

    public static void deployStaticBizAfterEmbedMasterBizStarted() {
        if (null == arkContainer) {
            throw new RuntimeException("ArkContainer is null when deploying biz after embed master biz started.");
        }
        try {
            ClassLoader containerClassLoader = arkContainer.getClass().getClassLoader();
            ClassLoader oldClassLoader = ClassLoaderUtils.pushContextClassLoader((ClassLoader)containerClassLoader);
            Method deployBizMethod = arkContainer.getClass().getMethod("deployBizAfterMasterBizReady", new Class[0]);
            deployBizMethod.invoke(arkContainer, new Object[0]);
            ClassLoaderUtils.popContextClassLoader((ClassLoader)oldClassLoader);
        }
        catch (Exception e) {
            throw new RuntimeException("Meet exception when deploying biz after embed master biz started!", e);
        }
    }
}

