/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.listener;

import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.support.common.DelegateArkContainer;
import com.alipay.sofa.ark.support.listener.TestNGOnArk;
import java.util.List;
import org.testng.IAlterSuiteListener;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class ArkTestNGAlterSuiteListener
implements IAlterSuiteListener {
    public void alter(List<XmlSuite> suites) {
        for (XmlSuite xmlSuite : suites) {
            this.resetXmlSuite(xmlSuite);
            this.resetChildrenXmlSuite(xmlSuite.getChildSuites());
        }
    }

    protected void resetXmlSuite(XmlSuite suite) {
        if (suite == null) {
            return;
        }
        this.resetXmlSuite(suite.getParentSuite());
        this.resetSingleXmlSuite(suite);
    }

    protected void resetChildrenXmlSuite(List<XmlSuite> childSuites) {
        if (childSuites.isEmpty()) {
            return;
        }
        for (XmlSuite xmlSuite : childSuites) {
            this.resetChildrenXmlSuite(xmlSuite.getChildSuites());
            this.resetSingleXmlSuite(xmlSuite);
        }
    }

    protected void resetSingleXmlSuite(XmlSuite suite) {
        for (XmlTest xmlTest : suite.getTests()) {
            for (XmlClass xmlClass : xmlTest.getClasses()) {
                Class testClass = xmlClass.getSupportClass();
                if (testClass.getAnnotation(TestNGOnArk.class) == null) continue;
                if (!DelegateArkContainer.isStarted()) {
                    DelegateArkContainer.launch(testClass);
                }
                try {
                    xmlClass.setClass(DelegateArkContainer.getTestClassLoader().loadClass(testClass.getCanonicalName()));
                }
                catch (ClassNotFoundException ex) {
                    throw new ArkRuntimeException(String.format("Load testNG test class %s failed.", testClass.getCanonicalName()), (Throwable)ex);
                }
            }
        }
    }
}

